/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.record.DNSSEC;
import io.milton.dns.record.KEYRecord;
import io.milton.dns.record.Message;
import io.milton.dns.record.Options;
import io.milton.dns.record.Record;
import io.milton.dns.record.SIGRecord;
import java.security.PrivateKey;
import java.util.Date;

public class SIG0 {
    private static final short VALIDITY = 300;

    private SIG0() {
    }

    public static void signMessage(Message message, KEYRecord key, PrivateKey privkey, SIGRecord previous) throws DNSSEC.DNSSECException {
        int validity = Options.intValue("sig0validity");
        if (validity < 0) {
            validity = 300;
        }
        long now = System.currentTimeMillis();
        Date timeSigned = new Date(now);
        Date timeExpires = new Date(now + (long)(validity * 1000));
        SIGRecord sig = DNSSEC.signMessage(message, previous, key, privkey, timeSigned, timeExpires);
        message.addRecord(sig, 3);
    }

    public static void verifyMessage(Message message, byte[] b, KEYRecord key, SIGRecord previous) throws DNSSEC.DNSSECException {
        Record[] additional;
        SIGRecord sig = null;
        for (Record record : additional = message.getSectionArray(3)) {
            if (record.getType() != 24 || ((SIGRecord)record).getTypeCovered() != 0) continue;
            sig = (SIGRecord)record;
            break;
        }
        DNSSEC.verifyMessage(message, b, sig, previous, key);
    }
}

