/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.ICalData;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoEventResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;

public class ICalDataAnnotationHandler
extends AbstractAnnotationHandler {
    private final String[] CTAG_PROP_NAMES = new String[]{"ical", "icalData"};

    public ICalDataAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, ICalData.class, new Request.Method[0]);
    }

    public String execute(AnnoEventResource eventRes) {
        Object source = eventRes.getSource();
        try {
            Object value = null;
            ControllerMethod cm = this.getBestMethod(source.getClass());
            if (cm == null) {
                Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
                if (m != null) {
                    value = m.invoke(source, new Object[]{null});
                } else {
                    for (String nameProp : this.CTAG_PROP_NAMES) {
                        if (!PropertyUtils.isReadable((Object)source, (String)nameProp)) continue;
                        value = PropertyUtils.getProperty((Object)source, (String)nameProp);
                        break;
                    }
                }
            } else {
                byte[] arr;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                value = this.invoke(cm, eventRes, bout);
                if (value == null && (arr = bout.toByteArray()).length > 0) {
                    value = arr;
                }
            }
            if (value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    return new String(bytes, "UTF-8");
                }
                if (value instanceof InputStream) {
                    InputStream in = (InputStream)value;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)bout);
                    return bout.toString("UTF-8");
                }
                return value.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.getClass() + " - " + source.getClass(), e);
        }
    }
}

