/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fck;

import io.milton.common.Path;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fck.FckFileManagerResource;
import io.milton.http.fck.FckQuickUploaderResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FckResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(FckResourceFactory.class);
    private final ResourceFactory wrappedFactory;

    public FckResourceFactory(ResourceFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    public Resource getResource(String host, String url) throws NotAuthorizedException, BadRequestException {
        CollectionResource h;
        Path path = Path.path((String)url);
        if (FckFileManagerResource.URL.equals((Object)path)) {
            CollectionResource h2 = this.getParent(host, path.getParent());
            if (h2 != null) {
                return new FckFileManagerResource(h2);
            }
        } else if (FckQuickUploaderResource.URL.equals((Object)path) && (h = this.getParent(host, path.getParent())) != null) {
            return new FckQuickUploaderResource(h);
        }
        return this.wrappedFactory.getResource(host, url);
    }

    private CollectionResource getParent(String host, Path path) throws NotAuthorizedException, BadRequestException {
        Resource r = this.wrappedFactory.getResource(host, path.toString());
        if (r instanceof CollectionResource) {
            return (CollectionResource)r;
        }
        log.warn("Could not locate a CollectionResource at: http://" + host + "/" + path);
        return null;
    }
}

