/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.servlet.MiltonServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class OutputStreamWrappingHttpServletResponse
extends HttpServletResponseWrapper {
    private final HttpServletResponse response;
    private final OutputStream out;
    private final PrintWriter writer;

    public OutputStreamWrappingHttpServletResponse(HttpServletResponse response, OutputStream out) {
        super(response);
        this.response = response;
        this.out = out;
        this.writer = new PrintWriter(out);
    }

    public String encodeUrl(String url) {
        return MiltonServlet.response().encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return MiltonServlet.response().encodeRedirectURL(url);
    }

    public void sendRedirect(String location) throws IOException {
        MiltonServlet.response().sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new WrappedOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        this.writer.flush();
        this.out.flush();
        this.response.flushBuffer();
    }

    public void setLocale(Locale loc) {
        MiltonServlet.response().setLocale(loc);
    }

    public Locale getLocale() {
        return MiltonServlet.response().getLocale();
    }

    private class WrappedOutputStream
    extends ServletOutputStream {
        private WrappedOutputStream() {
        }

        public void write(int b) throws IOException {
            OutputStreamWrappingHttpServletResponse.this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            OutputStreamWrappingHttpServletResponse.this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            OutputStreamWrappingHttpServletResponse.this.out.write(b, off, len);
        }
    }
}

