/*
 * Decompiled with CFR 0.152.
 */
package io.milton.cache;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import io.milton.cache.CacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCacheManager.class);
    private final HazelcastInstance hazel = Hazelcast.newHazelcastInstance();
    private final Cluster cluster;

    public HazelcastCacheManager() {
        log.info("Connected to hazelcast cluster");
        this.cluster = this.hazel.getCluster();
    }

    @Override
    public Map getMap(String name) {
        if (this.hazel != null) {
            return this.hazel.getMap(name);
        }
        log.warn("Not connected to hazelcast, using local data only");
        return new ConcurrentHashMap();
    }
}

