/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.ldap.LdapConnection;
import io.milton.ldap.LdapTransactionManager;
import io.milton.ldap.SearchManager;
import io.milton.ldap.UserFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(LdapServer.class);
    public static final int DEFAULT_PORT = 389;
    private final UserFactory userSessionFactory;
    private final SearchManager searchManager;
    private final LdapTransactionManager txManager;
    private final PropFindPropertyBuilder propFindPropertyBuilder;
    protected boolean nosslFlag;
    private int port;
    private String bindAddress;
    private boolean allowRemote = true;
    private File keystoreFile;
    private String keystoreType;
    private String keystorePass;
    private ServerSocket serverSocket;

    public LdapServer(LdapTransactionManager txManager, UserFactory userSessionFactory, int port, boolean nosslFlag, String bindAddress, PropFindPropertyBuilder propFindPropertyBuilder) {
        super(LdapServer.class.getName());
        this.txManager = txManager;
        this.searchManager = new SearchManager(txManager);
        this.setDaemon(true);
        this.port = port == 0 ? 389 : port;
        this.bindAddress = bindAddress;
        this.userSessionFactory = userSessionFactory;
        this.nosslFlag = nosslFlag;
        this.propFindPropertyBuilder = propFindPropertyBuilder;
    }

    public LdapServer(LdapTransactionManager txManager, UserFactory userSessionFactory, PropFindPropertyBuilder propFindPropertyBuilder) {
        super(LdapServer.class.getName());
        this.txManager = txManager;
        this.searchManager = new SearchManager(txManager);
        this.setDaemon(true);
        this.userSessionFactory = userSessionFactory;
        this.propFindPropertyBuilder = propFindPropertyBuilder;
        this.port = 389;
    }

    public LdapServer(LdapTransactionManager txManager, UserFactory userSessionFactory, WebDavProtocol webDavProtocol, PropFindPropertyBuilder propFindPropertyBuilder) {
        super(LdapServer.class.getName());
        this.txManager = txManager;
        this.searchManager = new SearchManager(txManager);
        this.setDaemon(true);
        this.userSessionFactory = userSessionFactory;
        this.port = 389;
        this.propFindPropertyBuilder = propFindPropertyBuilder;
    }

    public boolean isNosslFlag() {
        return this.nosslFlag;
    }

    public void setNosslFlag(boolean nosslFlag) {
        this.nosslFlag = nosslFlag;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocolName() {
        return "LDAP";
    }

    public LdapConnection createConnectionHandler(Socket clientSocket) {
        return new LdapConnection(clientSocket, this.userSessionFactory, this.searchManager, this.txManager, this.propFindPropertyBuilder);
    }

    @Override
    public synchronized void start() {
        try {
            log.info("Created server, binding to address. bind address: " + this.bindAddress + " port: " + this.port);
            this.bind();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        log.info("Starting the LDAP server thread");
        super.start();
    }

    public void bind() throws Exception {
        ServerSocketFactory serverSocketFactory;
        if (this.keystoreFile == null || this.keystoreFile.length() == 0L || this.nosslFlag) {
            serverSocketFactory = ServerSocketFactory.getDefault();
        } else {
            FileInputStream keyStoreInputStream = null;
            try {
                keyStoreInputStream = new FileInputStream(this.keystoreFile);
                KeyStore keystore = KeyStore.getInstance(this.keystoreType);
                keystore.load(keyStoreInputStream, this.keystorePass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keystore, this.keystorePass.toCharArray());
                SSLContext sslContext = SSLContext.getInstance("SSLv3");
                sslContext.init(kmf.getKeyManagers(), null, null);
                serverSocketFactory = sslContext.getServerSocketFactory();
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new Exception(ex);
            }
            finally {
                if (keyStoreInputStream != null) {
                    try {
                        keyStoreInputStream.close();
                    }
                    catch (IOException exc) {
                        log.error("exception closing stream", (Throwable)exc);
                    }
                }
            }
        }
        try {
            if (this.bindAddress == null || this.bindAddress.length() == 0) {
                log.info("Starting LDAP server on all interfaces and port: " + this.port);
                this.serverSocket = serverSocketFactory.createServerSocket(this.port);
            } else {
                log.info("Starting LDAP server on interface: " + this.bindAddress + " and port: " + this.port);
                this.serverSocket = serverSocketFactory.createServerSocket(this.port, 0, Inet4Address.getByName(this.bindAddress));
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket clientSocket = null;
        LdapConnection connection = null;
        try {
            try {
                while (true) {
                    System.out.println("Waiting for connection...");
                    clientSocket = this.serverSocket.accept();
                    System.out.println("Accepted socket from: " + clientSocket.getRemoteSocketAddress());
                    clientSocket.setSoTimeout(300000);
                    log.info("CONNECTION_FROM" + clientSocket.getInetAddress() + this.port);
                    if (this.allowRemote || clientSocket.getInetAddress().isLoopbackAddress()) {
                        connection = this.createConnectionHandler(clientSocket);
                        connection.start();
                        continue;
                    }
                    clientSocket.close();
                    log.warn("external connection refused");
                }
            }
            catch (IOException e) {
                if (!this.serverSocket.isClosed()) {
                    log.warn("exception", (Throwable)e);
                }
                try {
                    if (clientSocket != null) {
                        clientSocket.close();
                    }
                }
                catch (IOException e2) {
                    log.warn("exception", (Throwable)e2);
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException e) {
                log.warn("exception", (Throwable)e);
            }
            if (connection != null) {
                connection.close();
            }
            throw throwable;
        }
        System.out.println("LDAP Server has exited");
    }

    public void close() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            log.error("LOG_EXCEPTION_CLOSING_SERVER_SOCKET", (Throwable)e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public boolean isAllowRemote() {
        return this.allowRemote;
    }

    public void setAllowRemote(boolean allowRemote) {
        this.allowRemote = allowRemote;
    }
}

