/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import io.milton.http.AbstractResponse;
import io.milton.http.BeanCookie;
import io.milton.http.Cookie;
import io.milton.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.http.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyMiltonResponse
extends AbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyMiltonResponse.class);
    private final Response r;
    private final Map<String, String> headers = new HashMap<String, String>();

    public GrizzlyMiltonResponse(Response response) {
        this.r = response;
    }

    public Response.Status getStatus() {
        return Response.Status.fromCode((int)this.r.getStatus());
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setAuthenticateHeader(List<String> challenges) {
        for (String ch : challenges) {
            this.r.addHeader(Response.Header.WWW_AUTHENTICATE.code, ch);
        }
    }

    public void setStatus(Response.Status status) {
        this.r.setStatus(status.code);
    }

    public void setNonStandardHeader(String code, String value) {
        this.r.addHeader(code, value);
        this.headers.put(code, value);
    }

    public String getNonStandardHeader(String code) {
        return this.headers.get(code);
    }

    public OutputStream getOutputStream() {
        return this.r.getOutputStream();
    }

    public void close() {
    }

    public void sendError(Response.Status status, String message) {
        try {
            this.r.sendError(status.code, message);
        }
        catch (IllegalStateException e) {
            log.error("Failed to send error, response already commited", (Throwable)e);
        }
        catch (IOException ex) {
            log.error("Failed to send error", (Throwable)ex);
        }
        try {
            this.r.getOutputStream().close();
            log.info("Closed outputstream after sendError");
        }
        catch (Throwable e) {
            log.warn("Failed to close outputstream after sendError");
        }
    }

    public Cookie setCookie(Cookie cookie) {
        String h = BeanCookie.toHeader((Cookie)cookie);
        this.r.addHeader("Set-Cookie", h);
        return cookie;
    }

    public Cookie setCookie(String name, String value) {
        BeanCookie c = new BeanCookie(name);
        c.setValue(value);
        c.setPath("/");
        this.setCookie((Cookie)c);
        return c;
    }
}

