/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.common.Path;
import io.milton.http.LockManager;
import io.milton.http.PropertyManager;
import io.milton.http.ResourceFactory;
import io.milton.http.SecurityManager;
import io.milton.http.fs.FileContentService;
import io.milton.http.fs.FsDirectoryResource;
import io.milton.http.fs.FsFileResource;
import io.milton.http.fs.FsResource;
import io.milton.http.fs.NullSecurityManager;
import io.milton.http.fs.SimpleFileContentService;
import io.milton.resource.Resource;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(FileSystemResourceFactory.class);
    private FileContentService contentService = new SimpleFileContentService();
    File root;
    SecurityManager securityManager;
    LockManager lockManager;
    PropertyManager propertyManager;
    Long maxAgeSeconds;
    String contextPath;
    boolean allowDirectoryBrowsing;
    String defaultPage;
    boolean digestAllowed = true;
    private String ssoPrefix;

    public FileSystemResourceFactory() {
        log.debug("setting default configuration...");
        String sRoot = System.getProperty("user.home");
        NullSecurityManager sm = new NullSecurityManager();
        this.init(sRoot, sm);
    }

    protected void init(String sRoot, SecurityManager securityManager) {
        this.setRoot(new File(sRoot));
        this.setSecurityManager(securityManager);
    }

    public FileSystemResourceFactory(File root, SecurityManager securityManager) {
        this.setRoot(root);
        this.setSecurityManager(securityManager);
    }

    public FileSystemResourceFactory(File root, SecurityManager securityManager, String contextPath) {
        this.setRoot(root);
        this.setSecurityManager(securityManager);
        this.setContextPath(contextPath);
    }

    public File getRoot() {
        return this.root;
    }

    public final void setRoot(File root) {
        log.debug("root: " + root.getAbsolutePath());
        this.root = root;
        if (!root.exists()) {
            log.warn("Root folder does not exist: " + root.getAbsolutePath());
        }
        if (!root.isDirectory()) {
            log.warn("Root exists but is not a directory: " + root.getAbsolutePath());
        }
    }

    public Resource getResource(String host, String url) {
        log.debug("getResource: host: " + host + " - url:" + url);
        url = this.stripContext(url);
        File requested = this.resolvePath(this.root, url);
        return this.resolveFile(host, requested);
    }

    public FsResource resolveFile(String host, File file) {
        if (!file.exists()) {
            log.debug("file not found: " + file.getAbsolutePath());
            return null;
        }
        FsResource r = file.isDirectory() ? new FsDirectoryResource(host, this, file, this.contentService) : new FsFileResource(host, this, file, this.contentService);
        if (r != null) {
            r.ssoPrefix = this.ssoPrefix;
        }
        return r;
    }

    public File resolvePath(File root, String url) {
        Path path = Path.path((String)url);
        File f = root;
        for (String s : path.getParts()) {
            f = new File(f, s);
        }
        return f;
    }

    public String getRealm(String host) {
        String s = this.securityManager.getRealm(host);
        if (s == null) {
            throw new NullPointerException("Got null realm from securityManager: " + this.securityManager + " for host=" + host);
        }
        return s;
    }

    public Long maxAgeSeconds(FsResource resource) {
        return this.maxAgeSeconds;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (securityManager != null) {
            log.debug("securityManager: " + securityManager.getClass());
        } else {
            log.warn("Setting null FsSecurityManager. This WILL cause null pointer exceptions");
        }
        this.securityManager = securityManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setMaxAgeSeconds(Long maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public Long getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isAllowDirectoryBrowsing() {
        return this.allowDirectoryBrowsing;
    }

    public void setAllowDirectoryBrowsing(boolean allowDirectoryBrowsing) {
        this.allowDirectoryBrowsing = allowDirectoryBrowsing;
    }

    public String getDefaultPage() {
        return this.defaultPage;
    }

    public void setDefaultPage(String defaultPage) {
        this.defaultPage = defaultPage;
    }

    private String stripContext(String url) {
        if (this.contextPath != null && this.contextPath.length() > 0) {
            url = url.replaceFirst('/' + this.contextPath, "");
            log.debug("stripped context: " + url);
        }
        return url;
    }

    boolean isDigestAllowed() {
        boolean b;
        boolean bl = b = this.digestAllowed && this.securityManager != null && this.securityManager.isDigestAllowed();
        if (log.isTraceEnabled()) {
            log.trace("isDigestAllowed: " + b);
        }
        return b;
    }

    public void setDigestAllowed(boolean digestAllowed) {
        this.digestAllowed = digestAllowed;
    }

    public void setSsoPrefix(String ssoPrefix) {
        this.ssoPrefix = ssoPrefix;
    }

    public String getSsoPrefix() {
        return this.ssoPrefix;
    }

    public FileContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(FileContentService contentService) {
        this.contentService = contentService;
    }
}

