/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.Path;
import io.milton.event.Event;
import io.milton.event.NewFolderEvent;
import io.milton.http.Handler;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.CollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkColHandler
implements Handler {
    private static final Logger log = LoggerFactory.getLogger(MkColHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private CollectionResourceCreator collectionResourceCreator = new DefaultCollectionResourceCreator();

    public MkColHandler(WebDavResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.MKCOL.code};
    }

    @Override
    public boolean isCompatible(Resource r) {
        return r instanceof MakeCollectionableResource;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        try {
            this.process(manager, request, response, this.collectionResourceCreator);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void process(HttpManager manager, Request request, Response response, CollectionResourceCreator creator) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
        if (!this.handlerHelper.checkExpects(this.responseHandler, request, response)) {
            return;
        }
        String host = request.getHostHeader();
        String finalurl = HttpManager.decodeUrl(request.getAbsolutePath());
        if (log.isDebugEnabled()) {
            log.debug("process request: host: " + host + " url: " + finalurl);
        }
        Path finalpath = Path.path((String)finalurl);
        String name = finalpath.getName();
        Path parent = finalpath.getParent();
        String parenturl = parent.toString();
        Resource parentcol = manager.getResourceFactory().getResource(host, parenturl);
        if (parentcol != null) {
            log.debug("process: resource: " + parentcol.getClass().getName());
            if (this.handlerHelper.isNotCompatible(parentcol, request.getMethod())) {
                log.debug("resource not compatible. Resource class: " + parentcol.getClass() + " handler: " + this.getClass());
                this.responseHandler.respondMethodNotImplemented(parentcol, response, request);
                return;
            }
            if (this.handlerHelper.isLockedOut(request, parentcol)) {
                log.warn("isLockedOut");
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            Resource dest = manager.getResourceFactory().getResource(host, finalpath.toString());
            if (dest != null) {
                if (this.handlerHelper.isLockedOut(request, dest)) {
                    log.info("destination exists and is locked");
                    this.responseHandler.respondLocked(request, response, dest);
                } else {
                    log.info("destination exists and is not locked");
                    this.responseHandler.respondMethodNotAllowed(dest, response, request);
                }
                return;
            }
            if (this.handlerHelper.missingLock(request, parentcol) && this.handlerHelper.isLocked(dest)) {
                log.info("precondition failed");
                this.responseHandler.respondPreconditionFailed(request, response, dest);
                return;
            }
            if (parentcol instanceof CollectionResource) {
                CollectionResource col = (CollectionResource)parentcol;
                if (log.isTraceEnabled()) {
                    log.trace("process mkcol on parent: " + parentcol.getClass() + " with creator: " + creator.getClass());
                }
                this.processMakeCol(manager, request, response, col, name, creator);
            } else {
                log.warn("parent collection is no a CollectionResource: " + parentcol.getName());
                this.responseHandler.respondConflict(parentcol, response, request, "not a collection");
            }
        } else {
            log.warn("parent does not exist: host=" + host + " path=" + parenturl);
            manager.getResponseHandler().respondConflict(parentcol, response, request, name);
        }
    }

    private void processMakeCol(HttpManager manager, Request request, Response response, CollectionResource resource, String newName, CollectionResourceCreator creator) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
        if (!this.handlerHelper.checkAuthorisation(manager, (Resource)resource, request)) {
            log.info("not authorised");
            this.responseHandler.respondUnauthorised((Resource)resource, response, request);
            return;
        }
        this.handlerHelper.checkExpects(this.responseHandler, request, response);
        if (!this.isCompatible((Resource)resource)) {
            log.info("not compatible");
            this.responseHandler.respondMethodNotImplemented((Resource)resource, response, request);
            return;
        }
        MakeCollectionableResource existingCol = (MakeCollectionableResource)resource;
        Resource existingChild = existingCol.child(newName);
        if (existingChild != null) {
            log.warn("found already existing item: " + newName + " of type: " + existingChild.getClass() + " with actual name: " + existingChild.getName());
            this.responseHandler.respondMethodNotAllowed(existingChild, response, request);
            return;
        }
        CollectionResource made = creator.createResource(existingCol, newName, request);
        if (made == null) {
            log.warn("createCollection returned null. In resource class: " + existingCol.getClass());
            response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
        } else {
            log.info("created item ok: " + made.getClass());
            manager.getEventManager().fireEvent((Event)new NewFolderEvent(resource));
            response.setStatus(Response.Status.SC_CREATED);
        }
    }

    public CollectionResourceCreator getCollectionResourceCreator() {
        return this.collectionResourceCreator;
    }

    public void setCollectionResourceCreator(CollectionResourceCreator collectionResourceCreator) {
        this.collectionResourceCreator = collectionResourceCreator;
    }

    private static class DefaultCollectionResourceCreator
    implements CollectionResourceCreator {
        private DefaultCollectionResourceCreator() {
        }

        @Override
        public CollectionResource createResource(MakeCollectionableResource existingCol, String newName, Request request) throws ConflictException, NotAuthorizedException, BadRequestException, IOException {
            return existingCol.createCollection(newName);
        }
    }

    public static interface CollectionResourceCreator {
        public CollectionResource createResource(MakeCollectionableResource var1, String var2, Request var3) throws ConflictException, NotAuthorizedException, BadRequestException, IOException;
    }
}

