/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.http.LockInfo;
import io.milton.http.LockManager;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fs.FsResource;
import io.milton.resource.LockableResource;
import io.milton.resource.Resource;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsMemoryLockManager
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(FsMemoryLockManager.class);
    final Map<File, CurrentLock> locksByFile = new HashMap<File, CurrentLock>();
    final Map<String, CurrentLock> locksByToken = new HashMap<String, CurrentLock>();

    public synchronized LockResult lock(LockTimeout timeout, LockInfo lockInfo, LockableResource r) {
        FsResource resource = (FsResource)r;
        LockToken currentLock = this.currentLock(resource);
        if (currentLock != null) {
            return LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
        LockToken newToken = new LockToken(UUID.randomUUID().toString(), lockInfo, timeout);
        CurrentLock newLock = new CurrentLock(resource.getFile(), newToken, lockInfo.lockedByUser);
        this.locksByFile.put(resource.getFile(), newLock);
        this.locksByToken.put(newToken.tokenId, newLock);
        return LockResult.success((LockToken)newToken);
    }

    public synchronized LockResult refresh(String tokenId, LockableResource resource) {
        CurrentLock curLock = this.locksByToken.get(tokenId);
        if (curLock == null) {
            log.debug("can't refresh because no lock");
            return LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.PRECONDITION_FAILED);
        }
        curLock.token.setFrom(new Date());
        return LockResult.success((LockToken)curLock.token);
    }

    public synchronized void unlock(String tokenId, LockableResource r) throws NotAuthorizedException {
        FsResource resource = (FsResource)r;
        LockToken lockToken = this.currentLock(resource);
        if (lockToken == null) {
            log.debug("not locked");
            return;
        }
        if (!lockToken.tokenId.equals(tokenId)) {
            throw new NotAuthorizedException((Resource)resource);
        }
        this.removeLock(lockToken);
    }

    private LockToken currentLock(FsResource resource) {
        CurrentLock curLock = this.locksByFile.get(resource.getFile());
        if (curLock == null) {
            return null;
        }
        LockToken token = curLock.token;
        if (token.isExpired()) {
            this.removeLock(token);
            return null;
        }
        return token;
    }

    private void removeLock(LockToken token) {
        log.debug("removeLock: " + token.tokenId);
        CurrentLock currentLock = this.locksByToken.get(token.tokenId);
        if (currentLock != null) {
            this.locksByFile.remove(currentLock.file);
            this.locksByToken.remove(currentLock.token.tokenId);
        } else {
            log.warn("couldnt find lock: " + token.tokenId);
        }
    }

    public LockToken getCurrentToken(LockableResource r) {
        FsResource resource = (FsResource)r;
        CurrentLock lock = this.locksByFile.get(resource.getFile());
        if (lock == null) {
            return null;
        }
        LockToken token = new LockToken();
        token.info = new LockInfo(LockInfo.LockScope.EXCLUSIVE, LockInfo.LockType.WRITE, lock.lockedByUser, LockInfo.LockDepth.ZERO);
        token.info.lockedByUser = lock.lockedByUser;
        token.timeout = lock.token.timeout;
        token.tokenId = lock.token.tokenId;
        return token;
    }

    static class CurrentLock {
        final File file;
        final LockToken token;
        final String lockedByUser;

        public CurrentLock(File file, LockToken token, String lockedByUser) {
            this.file = file;
            this.token = token;
            this.lockedByUser = lockedByUser;
        }
    }
}

