/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.Utils;
import io.milton.http.HrefStatus;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.entity.MultiStatusEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.http.http11.Bufferable;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.quota.StorageChecker;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebDavResponseHandler
implements WebDavResponseHandler,
Bufferable {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebDavResponseHandler.class);
    protected final Http11ResponseHandler wrapped;
    protected final ResourceTypeHelper resourceTypeHelper;
    protected final PropFindXmlGenerator propFindXmlGenerator;

    public DefaultWebDavResponseHandler(Http11ResponseHandler wrapped, ResourceTypeHelper resourceTypeHelper, PropFindXmlGenerator propFindXmlGenerator) {
        this.wrapped = wrapped;
        this.resourceTypeHelper = resourceTypeHelper;
        this.propFindXmlGenerator = propFindXmlGenerator;
    }

    @Override
    public String generateEtag(Resource r) {
        return this.wrapped.generateEtag(r);
    }

    @Override
    public void respondWithOptions(Resource resource, Response response, Request request, List<String> methodsAllowed) {
        List<String> supportedLevels = this.resourceTypeHelper.getSupportedLevels(resource);
        String s = Utils.toCsv(supportedLevels);
        response.setDavHeader(s);
        response.setNonStandardHeader("MS-Author-Via", "DAV");
        this.wrapped.respondWithOptions(resource, response, request, methodsAllowed);
    }

    @Override
    public void responseMultiStatus(Resource resource, Response response, Request request, List<HrefStatus> statii) {
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setDateHeader(new Date());
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        List<String> supportedLevels = this.resourceTypeHelper.getSupportedLevels(resource);
        String s = Utils.toCsv(supportedLevels);
        response.setDavHeader(s);
        response.setEntity((Response.Entity)new MultiStatusEntity(statii));
    }

    @Override
    public void respondNoContent(Resource resource, Response response, Request request) {
        this.wrapped.respondNoContent(resource, response, request);
    }

    @Override
    public void respondContent(Resource resource, Response response, Request request, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        this.wrapped.respondContent(resource, response, request, params);
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, Range range) throws NotAuthorizedException, BadRequestException, NotFoundException {
        this.wrapped.respondPartialContent(resource, response, request, params, range);
    }

    @Override
    public void respondPartialContent(GetableResource resource, Response response, Request request, Map<String, String> params, List<Range> ranges) throws NotAuthorizedException, BadRequestException, NotFoundException {
        this.wrapped.respondPartialContent(resource, response, request, params, ranges);
    }

    @Override
    public void respondCreated(Resource resource, Response response, Request request) {
        this.wrapped.respondCreated(resource, response, request);
    }

    @Override
    public void respondUnauthorised(Resource resource, Response response, Request request) {
        this.wrapped.respondUnauthorised(resource, response, request);
    }

    @Override
    public void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        this.wrapped.respondMethodNotImplemented(resource, response, request);
    }

    @Override
    public void respondMethodNotAllowed(Resource res, Response response, Request request) {
        this.wrapped.respondMethodNotAllowed(res, response, request);
    }

    @Override
    public void respondConflict(Resource resource, Response response, Request request, String message) {
        this.wrapped.respondConflict(resource, response, request, message);
    }

    @Override
    public void respondRedirect(Response response, Request request, String redirectUrl) {
        this.wrapped.respondRedirect(response, request, redirectUrl);
    }

    @Override
    public void respondNotModified(GetableResource resource, Response response, Request request) {
        if (log.isTraceEnabled()) {
            log.trace("respondNotModified: " + this.wrapped.getClass().getCanonicalName());
        }
        this.wrapped.respondNotModified(resource, response, request);
    }

    @Override
    public void respondNotFound(Response response, Request request) {
        this.wrapped.respondNotFound(response, request);
    }

    @Override
    public void respondHead(Resource resource, Response response, Request request) {
        this.wrapped.respondHead(resource, response, request);
    }

    @Override
    public void respondExpectationFailed(Response response, Request request) {
        this.wrapped.respondExpectationFailed(response, request);
    }

    @Override
    public void respondBadRequest(Resource resource, Response response, Request request) {
        this.wrapped.respondBadRequest(resource, response, request);
    }

    @Override
    public void respondForbidden(Resource resource, Response response, Request request) {
        this.wrapped.respondForbidden(resource, response, request);
    }

    @Override
    public void respondServerError(Request request, Response response, String reason) {
        this.wrapped.respondServerError(request, response, reason);
    }

    @Override
    public void respondDeleteFailed(Request request, Response response, Resource resource, Response.Status status) {
        ArrayList<HrefStatus> statii = new ArrayList<HrefStatus>();
        statii.add(new HrefStatus(request.getAbsoluteUrl(), status));
        this.responseMultiStatus(resource, response, request, statii);
    }

    @Override
    public void respondPropFind(List<PropFindResponse> propFindResponses, Response response, Request request, Resource r) {
        log.trace("respondPropFind");
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setDateHeader(new Date());
        response.setContentTypeHeader("application/xml; charset=utf-8");
        List<String> supportedLevels = this.resourceTypeHelper.getSupportedLevels(r);
        String s = Utils.toCsv(supportedLevels);
        response.setDavHeader(s);
        OutputStream outputStream = response.getOutputStream();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            boolean sendErrorProps = !this.isBriefHeader(request);
            this.propFindXmlGenerator.generate(propFindResponses, bout, sendErrorProps);
            if (log.isTraceEnabled()) {
                log.trace("Propfind response ----");
                log.trace(bout.toString());
                log.trace("----");
            }
            byte[] arr = bout.toByteArray();
            outputStream.write(arr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            outputStream.flush();
        }
        catch (IOException ex) {
            log.warn("exception flushing response", (Throwable)ex);
        }
    }

    @Override
    public void respondInsufficientStorage(Request request, Response response, StorageChecker.StorageErrorReason storageErrorReason) {
        response.setStatus(Response.Status.SC_INSUFFICIENT_STORAGE);
    }

    @Override
    public void respondLocked(Request request, Response response, Resource existingResource) {
        response.setStatus(Response.Status.SC_LOCKED);
    }

    @Override
    public void respondPreconditionFailed(Request request, Response response, Resource resource) {
        this.wrapped.respondPreconditionFailed(request, response, resource);
    }

    @Override
    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        if (this.wrapped instanceof Bufferable) {
            return ((Bufferable)((Object)this.wrapped)).getBuffering();
        }
        throw new RuntimeException("Wrapped class is not a known type");
    }

    @Override
    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        if (!(this.wrapped instanceof Bufferable)) {
            throw new RuntimeException("Wrapped class is not a known type");
        }
        ((Bufferable)((Object)this.wrapped)).setBuffering(buffering);
    }

    private boolean isBriefHeader(Request request) {
        String b = (String)request.getHeaders().get("Brief");
        return "t".equals(b);
    }
}

