/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Address;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.EDNSOption;
import io.milton.dns.record.WireParseException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ClientSubnetOption
extends EDNSOption {
    private static final long serialVersionUID = -3868158449890266347L;
    private int family;
    private int sourceNetmask;
    private int scopeNetmask;
    private InetAddress address;

    ClientSubnetOption() {
        super(20730);
    }

    private static int checkMaskLength(String field, int family, int val) {
        int max = Address.addressLength(family) * 8;
        if (val < 0 || val > max) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + " must be in the range [0.." + max + "]");
        }
        return val;
    }

    public ClientSubnetOption(int sourceNetmask, int scopeNetmask, InetAddress address) {
        super(20730);
        this.family = Address.familyOf(address);
        this.sourceNetmask = ClientSubnetOption.checkMaskLength("source netmask", this.family, sourceNetmask);
        this.scopeNetmask = ClientSubnetOption.checkMaskLength("scope netmask", this.family, scopeNetmask);
        this.address = Address.truncate(address, sourceNetmask);
        if (!address.equals(this.address)) {
            throw new IllegalArgumentException("source netmask is not valid for address");
        }
    }

    public ClientSubnetOption(int sourceNetmask, InetAddress address) {
        this(sourceNetmask, 0, address);
    }

    public int getFamily() {
        return this.family;
    }

    public int getSourceNetmask() {
        return this.sourceNetmask;
    }

    public int getScopeNetmask() {
        return this.scopeNetmask;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    void optionFromWire(DNSInput in) throws WireParseException {
        this.family = in.readU16();
        if (this.family != 1 && this.family != 2) {
            throw new WireParseException("unknown address family");
        }
        this.sourceNetmask = in.readU8();
        if (this.sourceNetmask > Address.addressLength(this.family) * 8) {
            throw new WireParseException("invalid source netmask");
        }
        this.scopeNetmask = in.readU8();
        if (this.scopeNetmask > Address.addressLength(this.family) * 8) {
            throw new WireParseException("invalid scope netmask");
        }
        byte[] addr = in.readByteArray();
        if (addr.length != (this.sourceNetmask + 7) / 8) {
            throw new WireParseException("invalid address");
        }
        byte[] fulladdr = new byte[Address.addressLength(this.family)];
        System.arraycopy(addr, 0, fulladdr, 0, addr.length);
        try {
            this.address = InetAddress.getByAddress(fulladdr);
        }
        catch (UnknownHostException e) {
            throw new WireParseException("invalid address", e);
        }
        InetAddress tmp = Address.truncate(this.address, this.sourceNetmask);
        if (!tmp.equals(this.address)) {
            throw new WireParseException("invalid padding");
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        out.writeU16(this.family);
        out.writeU8(this.sourceNetmask);
        out.writeU8(this.scopeNetmask);
        out.writeByteArray(this.address.getAddress(), 0, (this.sourceNetmask + 7) / 8);
    }

    @Override
    String optionToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.address.getHostAddress());
        sb.append("/");
        sb.append(this.sourceNetmask);
        sb.append(", scope netmask ");
        sb.append(this.scopeNetmask);
        return sb.toString();
    }
}

