/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoFileResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.resource.ICalResource;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoEventResource
extends AnnoFileResource
implements ICalResource {
    private static final Logger log = LoggerFactory.getLogger(AnnoEventResource.class);

    public AnnoEventResource(AnnotationResourceFactory outer, Object source, AnnoCollectionResource parent) {
        super(outer, source, parent);
    }

    public String getICalData() {
        return this.annoFactory.iCalDataAnnotationHandler.execute(this);
    }

    @Override
    public boolean is(String type) {
        if (type.equals("event")) {
            return true;
        }
        return super.is(type);
    }

    @Override
    public String getUniqueId() {
        String s = super.getUniqueId();
        if (s == null) {
            log.warn("No unique ID for event class: " + this.source.getClass() + " Locking and other vital operations will not be available!!");
        }
        return s;
    }

    @Override
    public Date getModifiedDate() {
        Date dt = super.getModifiedDate();
        if (dt == null) {
            log.warn("No ModifiedDate for event class: " + this.source.getClass() + " This will cause incorrect calendar syncronisation!!!");
        }
        return dt;
    }

    @Override
    public String getContentType(String accepts) {
        return "text/calendar";
    }
}

