/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.http.Auth;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.XmlWriter;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fs.FileContentService;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.FsFileResource;
import io.milton.http.fs.FsResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.CopyableResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.GetableResource;
import io.milton.resource.LockingCollectionResource;
import io.milton.resource.MakeCollectionableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsDirectoryResource
extends FsResource
implements MakeCollectionableResource,
PutableResource,
CopyableResource,
DeletableResource,
MoveableResource,
PropFindableResource,
LockingCollectionResource,
GetableResource {
    private static final Logger log = LoggerFactory.getLogger(FsDirectoryResource.class);
    private final FileContentService contentService;

    public FsDirectoryResource(String host, FileSystemResourceFactory factory, File dir, FileContentService contentService) {
        super(host, factory, dir);
        this.contentService = contentService;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + dir.getAbsolutePath());
        }
    }

    public CollectionResource createCollection(String name) {
        File fnew = new File(this.file, name);
        boolean ok = fnew.mkdir();
        if (!ok) {
            throw new RuntimeException("Failed to create: " + fnew.getAbsolutePath());
        }
        return new FsDirectoryResource(this.host, this.factory, fnew, this.contentService);
    }

    public Resource child(String name) {
        File fchild = new File(this.file, name);
        return this.factory.resolveFile(this.host, fchild);
    }

    public List<? extends Resource> getChildren() {
        File[] files;
        ArrayList<FsResource> list = new ArrayList<FsResource>();
        for (File fchild : files = (File[])Arrays.stream((Object[])Optional.ofNullable(this.file.listFiles()).orElse(new File[0])).sorted(Comparator.comparing(File::isDirectory).reversed().thenComparing(File::getName)).toArray(File[]::new)) {
            FsResource res = this.factory.resolveFile(this.host, fchild);
            if (res != null) {
                list.add(res);
                continue;
            }
            log.error("Couldnt resolve file {}", (Object)fchild.getAbsolutePath());
        }
        return list;
    }

    public String checkRedirect(Request request) {
        if (this.factory.getDefaultPage() != null) {
            boolean hasSlash = request.getAbsoluteUrl().endsWith("/");
            return (hasSlash ? request.getAbsoluteUrl() : request.getAbsoluteUrl() + "/") + this.factory.getDefaultPage();
        }
        return null;
    }

    public Resource createNew(String name, InputStream in, Long length, String contentType) throws IOException {
        File dest = new File(this.getFile(), name);
        this.contentService.setFileContent(dest, in);
        return this.factory.resolveFile(this.host, dest);
    }

    @Override
    protected void doCopy(File dest) throws NotAuthorizedException {
        try {
            if (this.isRecursive(dest)) {
                throw new NotAuthorizedException("Cannot copy to subfolder", (Resource)this, 403);
            }
            FileUtils.copyDirectory((File)this.getFile(), (File)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to copy to:" + dest.getAbsolutePath(), ex);
        }
    }

    private boolean isRecursive(File dest) throws IOException {
        return dest.getCanonicalPath().startsWith(this.file.getCanonicalPath());
    }

    public LockToken createAndLock(String name, LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException {
        File dest = new File(this.getFile(), name);
        this.createEmptyFile(dest);
        FsFileResource newRes = new FsFileResource(this.host, this.factory, dest, this.contentService);
        LockResult res = newRes.lock(timeout, lockInfo);
        return res.getLockToken();
    }

    private void createEmptyFile(File file) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        XmlWriter w = new XmlWriter(out);
        w.open("html");
        w.open("head");
        w.writeText("<script type=\"text/javascript\" language=\"javascript1.1\">\n    var fNewDoc = false;\n  </script>\n  <script LANGUAGE=\"VBSCRIPT\">\n    On Error Resume Next\n    Set EditDocumentButton = CreateObject(\"SharePoint.OpenDocuments.3\")\n    fNewDoc = IsObject(EditDocumentButton)\n  </script>\n  <script type=\"text/javascript\" language=\"javascript1.1\">\n    var L_EditDocumentError_Text = \"The edit feature requires a SharePoint-compatible application and Microsoft Internet Explorer 4.0 or greater.\";\n    var L_EditDocumentRuntimeError_Text = \"Sorry, couldnt open the document.\";\n    function editDocument(strDocument) {\n      strDocument = 'http://192.168.1.2:8080' + strDocument;       if (fNewDoc) {\n        if (!EditDocumentButton.EditDocument(strDocument)) {\n          alert(L_EditDocumentRuntimeError_Text + ' - ' + strDocument); \n        }\n      } else { \n        alert(L_EditDocumentError_Text + ' - ' + strDocument); \n      }\n    }\n  </script>\n");
        w.close("head");
        w.open("body");
        w.begin("h1").open().writeText(this.getName()).close();
        w.open("table");
        for (Resource resource : this.getChildren()) {
            w.open("tr");
            w.open("td");
            String path = this.buildHref(this.getFile().getCanonicalPath().substring(this.factory.getRoot().getCanonicalPath().length()).replace('\\', '/'), resource.getName());
            w.begin("a").writeAtt("href", path).open().writeText(resource.getName()).close();
            w.begin("a").writeAtt("href", "#").writeAtt("onclick", "editDocument('" + path + "')").open().writeText("(edit with office)").close();
            w.close("td");
            w.begin("td").open().writeText(resource.getModifiedDate() + "").close();
            w.close("tr");
        }
        w.close("table");
        w.close("body");
        w.close("html");
        w.flush();
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return "text/html";
    }

    public Long getContentLength() {
        return null;
    }

    private String buildHref(String uri, String name) {
        String abUrl = uri;
        if (!abUrl.endsWith("/")) {
            abUrl = abUrl + "/";
        }
        if (this.ssoPrefix == null) {
            return abUrl + name;
        }
        String s = FsDirectoryResource.insertSsoPrefix(abUrl, this.ssoPrefix);
        s = s + name;
        return s;
    }

    public static String insertSsoPrefix(String abUrl, String prefix) {
        int pos = abUrl.indexOf("/", 8);
        String s = abUrl.substring(0, pos) + "/" + prefix;
        s = s + abUrl.substring(pos);
        return s;
    }
}

