/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.record.ClientSubnetOption;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.GenericEDNSOption;
import io.milton.dns.record.Mnemonic;
import io.milton.dns.record.NSIDOption;
import io.milton.dns.record.Record;
import io.milton.dns.record.WireParseException;
import java.io.IOException;
import java.util.Arrays;

public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int code) {
        this.code = Record.checkU16("code", code);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(Code.string(this.code));
        sb.append(": ");
        sb.append(this.optionToString());
        sb.append("}");
        return sb.toString();
    }

    public int getCode() {
        return this.code;
    }

    byte[] getData() {
        DNSOutput out = new DNSOutput();
        this.optionToWire(out);
        return out.toByteArray();
    }

    abstract void optionFromWire(DNSInput var1) throws IOException;

    public static EDNSOption fromWire(DNSInput in) throws IOException {
        EDNSOption option;
        int code = in.readU16();
        int length = in.readU16();
        if (in.remaining() < length) {
            throw new WireParseException("truncated option");
        }
        int save = in.saveActive();
        in.setActive(length);
        switch (code) {
            case 3: {
                option = new NSIDOption();
                break;
            }
            case 20730: {
                option = new ClientSubnetOption();
                break;
            }
            default: {
                option = new GenericEDNSOption(code);
            }
        }
        option.optionFromWire(in);
        in.restoreActive(save);
        return option;
    }

    public static EDNSOption fromWire(byte[] b) throws IOException {
        return EDNSOption.fromWire(new DNSInput(b));
    }

    abstract void optionToWire(DNSOutput var1);

    public void toWire(DNSOutput out) {
        out.writeU16(this.code);
        int lengthPosition = out.current();
        out.writeU16(0);
        this.optionToWire(out);
        int length = out.current() - lengthPosition - 2;
        out.writeU16At(length, lengthPosition);
    }

    public byte[] toWire() throws IOException {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof EDNSOption)) {
            return false;
        }
        EDNSOption opt = (EDNSOption)arg;
        if (this.code != opt.code) {
            return false;
        }
        return Arrays.equals(this.getData(), opt.getData());
    }

    public int hashCode() {
        byte[] array = this.getData();
        int hashval = 0;
        for (byte b : array) {
            hashval += (hashval << 3) + (b & 0xFF);
        }
        return hashval;
    }

    abstract String optionToString();

    public static class Code {
        public static final int NSID = 3;
        public static final int CLIENT_SUBNET = 20730;
        private static final Mnemonic codes = new Mnemonic("EDNS Option Codes", 2);

        private Code() {
        }

        public static String string(int code) {
            return codes.getText(code);
        }

        public static int value(String s) {
            return codes.getValue(s);
        }

        static {
            codes.setMaximum(65535);
            codes.setPrefix("CODE");
            codes.setNumericAllowed(true);
            codes.add(3, "NSID");
            codes.add(20730, "CLIENT_SUBNET");
        }
    }
}

