/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.common.Utils;
import io.milton.http.OAuth2TokenResponse;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.values.Pair;
import io.milton.resource.OAuth2Provider;
import io.milton.resource.OAuth2Resource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Helper {
    private static final Logger log = LoggerFactory.getLogger(OAuth2Helper.class);
    private final NonceProvider nonceProvider;

    public static URL getOAuth2URL(OAuth2Provider provider, String returnUrl) {
        log.trace("getOAuth2URL {}", (Object)provider);
        String oAuth2Location = provider.getAuthLocation();
        String oAuth2ClientId = provider.getClientId();
        String scopes = Utils.toCsv((Collection)provider.getPermissionScopes(), (boolean)false);
        try {
            String state = OAuth2Helper.toState(provider.getProviderId(), returnUrl);
            OAuthClientRequest oAuthRequest = OAuthClientRequest.authorizationLocation((String)oAuth2Location).setClientId(oAuth2ClientId).setResponseType("code").setScope(scopes).setState(state).setRedirectURI(provider.getRedirectURI()).buildQueryMessage();
            return new URL(oAuthRequest.getLocationUri());
        }
        catch (MalformedURLException | OAuthSystemException oAuthSystemException) {
            throw new RuntimeException(oAuthSystemException);
        }
    }

    public static String toState(String providerId, String returnUrl) {
        StringBuilder sb = new StringBuilder(providerId);
        if (returnUrl != null) {
            sb.append("||");
            sb.append(returnUrl);
        }
        byte[] arr = Base64.encode((byte[])sb.toString().getBytes());
        return new String(arr);
    }

    public static Pair<String, String> parseState(String encoded) {
        String r;
        String p;
        String decoded = new String(Base64.decode((String)encoded));
        int i = decoded.indexOf("||");
        if (i > 0) {
            p = decoded.substring(0, i);
            r = decoded.substring(i + 2);
        } else {
            p = decoded;
            r = null;
        }
        return new Pair((Object)p, r);
    }

    public OAuth2Helper(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
    }

    public OAuthAccessTokenResponse obtainAuth2Token(OAuth2Provider provider, String accessCode) throws OAuthSystemException, OAuthProblemException {
        log.trace("obtainAuth2Token code={}, provider={}", (Object)accessCode, (Object)provider);
        String oAuth2ClientId = provider.getClientId();
        String oAuth2TokenLocation = provider.getTokenLocation();
        String oAuth2ClientSecret = provider.getClientSecret();
        String oAuth2RedirectURI = provider.getRedirectURI();
        OAuthClientRequest oAuthRequest = OAuthClientRequest.tokenLocation((String)oAuth2TokenLocation).setGrantType(GrantType.AUTHORIZATION_CODE).setRedirectURI(oAuth2RedirectURI).setCode(accessCode).setClientId(oAuth2ClientId).setClientSecret(oAuth2ClientSecret).buildBodyMessage();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthAccessTokenResponse oAuth2Response2 = oAuthClient.accessToken(oAuthRequest, OAuth2TokenResponse.class);
        return oAuth2Response2;
    }

    public OAuthResourceResponse getOAuth2Profile(OAuthAccessTokenResponse oAuth2Response, OAuth2Provider provider) throws OAuthSystemException, OAuthProblemException {
        log.trace("getOAuth2Profile start {}", (Object)oAuth2Response);
        String accessToken = oAuth2Response.getAccessToken();
        String userProfileLocation = provider.getProfileLocation();
        if (StringUtils.isNotBlank((String)userProfileLocation)) {
            OAuthClientRequest bearerClientRequest;
            OAuthBearerClientRequest builder = new OAuthBearerClientRequest(userProfileLocation).setAccessToken(accessToken);
            if (null == provider.getOAuth2AccessTokenType()) {
                bearerClientRequest = builder.buildQueryMessage();
            } else {
                switch (provider.getOAuth2AccessTokenType()) {
                    case REQUEST_PARAM: {
                        bearerClientRequest = builder.buildQueryMessage();
                        break;
                    }
                    case BEARER: {
                        bearerClientRequest = builder.buildHeaderMessage();
                        break;
                    }
                    case BODY: {
                        bearerClientRequest = builder.buildBodyMessage();
                        break;
                    }
                    default: {
                        bearerClientRequest = builder.buildQueryMessage();
                    }
                }
            }
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            return (OAuthResourceResponse)oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        }
        return null;
    }

    public OAuth2Resource.OAuth2ProfileDetails getOAuth2UserInfo(Request request, OAuthResourceResponse resourceResponse, OAuthAccessTokenResponse tokenResponse, OAuth2Provider prov, String oAuth2Code, String returnUrl) throws BadRequestException {
        log.trace(" getOAuth2UserId start..." + resourceResponse);
        Map responseMap = null;
        if (resourceResponse != null) {
            String resourceResponseBody = resourceResponse.getBody();
            log.trace(" OAuthResourceResponse, body{}" + resourceResponseBody);
            request.getAttributes().put("_oauthJson", resourceResponseBody);
            responseMap = JSONUtils.parseJSON((String)resourceResponseBody);
            String userID = (String)responseMap.get("id");
            String userName = (String)responseMap.get("username");
            String message = (String)responseMap.get("message");
            int status = -1;
            Object errCode = responseMap.get("status");
            if (errCode instanceof Integer) {
                status = (Integer)errCode;
            } else if (errCode instanceof String) {
                status = Integer.parseInt((String)errCode);
            }
            if (status >= 400) {
                throw new BadRequestException(message);
            }
            if (log.isTraceEnabled()) {
                log.trace(" userID{}" + userID);
                log.trace(" userName{}" + userName);
            }
        }
        OAuth2Resource.OAuth2ProfileDetails user = new OAuth2Resource.OAuth2ProfileDetails();
        user.setCode(oAuth2Code);
        user.setAccessToken(tokenResponse.getAccessToken());
        user.setRefreshToken(tokenResponse.getRefreshToken());
        user.setExpiresIn(tokenResponse.getExpiresIn());
        user.setDetails(responseMap);
        user.setReturnUrl(returnUrl);
        if (prov != null) {
            user.setTokenLocation(prov.getTokenLocation());
            user.setProviderId(prov.getProviderId());
        }
        if (log.isTraceEnabled()) {
            log.trace(" oAuth2Code{}" + oAuth2Code);
            log.trace(" AccessToken{}" + user.getAccessToken());
            log.trace("\n\n");
        }
        return user;
    }
}

