/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.config.HttpManagerBuilder;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.template.JspViewResolver;
import io.milton.mail.MailServer;
import io.milton.mail.MailServerBuilder;
import io.milton.servlet.FilterConfigWrapper;
import io.milton.servlet.MiltonServlet;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringMiltonFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SpringMiltonFilter.class);
    private ConfigurableApplicationContext context;
    private HttpManager httpManager;
    private MailServer mailServer;
    private ServletContext servletContext;
    private String[] excludeMiltonPaths;
    private static final String EXCLUDE_PATHS_SYSPROP = "milton.exclude.paths";

    public void init(FilterConfig fc) throws ServletException {
        log.info("init");
        this.initSpringApplicationContext(fc);
        this.servletContext = fc.getServletContext();
        String sExcludePaths = fc.getInitParameter(EXCLUDE_PATHS_SYSPROP);
        if (sExcludePaths != null) {
            log.info("init: exclude paths: " + sExcludePaths);
            this.excludeMiltonPaths = sExcludePaths.split(",");
        } else {
            log.info("init: exclude paths property has not been set in filter init param milton.exclude.paths");
        }
        Object milton = this.context.getBean("milton.http.manager");
        if (milton instanceof HttpManager) {
            this.httpManager = (HttpManager)milton;
        } else if (milton instanceof HttpManagerBuilder) {
            AnnotationResourceFactory arf;
            HttpManagerBuilder builder = (HttpManagerBuilder)milton;
            ResourceFactory rf = builder.getMainResourceFactory();
            if (rf instanceof AnnotationResourceFactory && (arf = (AnnotationResourceFactory)rf).getViewResolver() == null) {
                JspViewResolver viewResolver = new JspViewResolver(this.servletContext);
                arf.setViewResolver(viewResolver);
            }
            this.httpManager = builder.buildHttpManager();
        }
        if (this.context.containsBean("milton.mail.server")) {
            log.info("init mailserver...");
            Object oMailServer = this.context.getBean("milton.mail.server");
            if (oMailServer instanceof MailServer) {
                this.mailServer = (MailServer)oMailServer;
            } else if (oMailServer instanceof MailServerBuilder) {
                MailServerBuilder builder = (MailServerBuilder)oMailServer;
                this.mailServer = builder.build();
            } else {
                throw new RuntimeException("Unsupported type: " + oMailServer.getClass() + " expected " + MailServer.class + " or " + MailServerBuilder.class);
            }
            log.info("starting mailserver");
            this.mailServer.start();
        }
        log.info("Finished init");
    }

    protected void initSpringApplicationContext(FilterConfig fc) {
        StaticApplicationContext parent;
        WebApplicationContext rootContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)fc.getServletContext());
        if (rootContext != null) {
            log.info("Found a root spring context, and using it");
            parent = new StaticApplicationContext((ApplicationContext)rootContext);
        } else {
            log.info("No root spring context");
            parent = new StaticApplicationContext();
        }
        FilterConfigWrapper configWrapper = new FilterConfigWrapper(fc);
        parent.getBeanFactory().registerSingleton("config", (Object)configWrapper);
        parent.getBeanFactory().registerSingleton("servletContext", (Object)fc.getServletContext());
        File webRoot = new File(fc.getServletContext().getRealPath("/"));
        parent.getBeanFactory().registerSingleton("webRoot", (Object)webRoot);
        log.info("Registered root webapp path in: webroot=" + webRoot.getAbsolutePath());
        parent.refresh();
        String configClass = fc.getInitParameter("contextConfigClass");
        String sFiles = fc.getInitParameter("contextConfigLocation");
        ClassPathXmlApplicationContext ctx = null;
        if (StringUtils.isNotBlank((String)configClass)) {
            try {
                Class<?> clazz = Class.forName(configClass);
                AnnotationConfigApplicationContext annotationCtx = new AnnotationConfigApplicationContext();
                annotationCtx.setParent((ApplicationContext)parent);
                annotationCtx.register(new Class[]{clazz});
                annotationCtx.refresh();
                ctx = annotationCtx;
            }
            catch (ClassNotFoundException e) {
                ctx = null;
                log.error("Unable to create a child context for Milton", (Throwable)e);
            }
        } else {
            String[] contextFiles = sFiles != null && sFiles.trim().length() > 0 ? sFiles.split(" ") : new String[]{"applicationContext.xml"};
            try {
                ctx = new ClassPathXmlApplicationContext(contextFiles, (ApplicationContext)parent);
            }
            catch (BeansException e) {
                log.error("Unable to create a child context for Milton", (Throwable)e);
            }
        }
        if (ctx == null) {
            log.warn("No child context available, only using parent context");
            this.context = parent;
        } else {
            this.context = ctx;
        }
    }

    public void doFilter(javax.servlet.ServletRequest req, javax.servlet.ServletResponse resp, FilterChain fc) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)req;
            String url = hsr.getRequestURI();
            if (this.excludeMiltonPaths != null) {
                for (String s : this.excludeMiltonPaths) {
                    if (!url.startsWith(s)) continue;
                    log.trace("doFilter: is excluded path");
                    fc.doFilter(req, resp);
                    return;
                }
            }
        } else {
            log.trace("doFilter: request is not a supported type, continue with filter chain");
            fc.doFilter(req, resp);
            return;
        }
        log.trace("doFilter: begin milton processing");
        this.doMiltonProcessing((HttpServletRequest)req, (HttpServletResponse)resp);
    }

    public void destroy() {
        this.context.close();
        if (this.httpManager != null) {
            this.httpManager.shutdown();
        }
        if (this.mailServer != null) {
            this.mailServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMiltonProcessing(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            MiltonServlet.setThreadlocals(req, resp);
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            ServletRequest.clearThreadLocals();
            resp.flushBuffer();
        }
    }
}

