/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.record.CNAMERecord;
import io.milton.dns.record.DNAMERecord;
import io.milton.dns.record.RRset;
import java.util.ArrayList;
import java.util.List;

public class SetResponse {
    static final int UNKNOWN = 0;
    public static final int NXDOMAIN = 1;
    public static final int NXRRSET = 2;
    public static final int DELEGATION = 3;
    public static final int CNAME = 4;
    public static final int DNAME = 5;
    public static final int SUCCESSFUL = 6;
    private static final SetResponse unknown = new SetResponse(0);
    private static final SetResponse nxdomain = new SetResponse(1);
    private static final SetResponse nxrrset = new SetResponse(2);
    public int type;
    private Object data;

    private SetResponse() {
    }

    public SetResponse(int type, RRset rrset) {
        if (type < 0 || type > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = type;
        this.data = rrset;
    }

    public SetResponse(int type) {
        if (type < 0 || type > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = type;
        this.data = null;
    }

    public static SetResponse ofType(int type) {
        switch (type) {
            case 0: {
                return unknown;
            }
            case 1: {
                return nxdomain;
            }
            case 2: {
                return nxrrset;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                SetResponse sr = new SetResponse();
                sr.type = type;
                sr.data = null;
                return sr;
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    public void addRRset(RRset rrset) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        List l = (List)this.data;
        l.add(rrset);
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isNXDOMAIN() {
        return this.type == 1;
    }

    public boolean isNXRRSET() {
        return this.type == 2;
    }

    public boolean isDelegation() {
        return this.type == 3;
    }

    public boolean isCNAME() {
        return this.type == 4;
    }

    public boolean isDNAME() {
        return this.type == 5;
    }

    public boolean isSuccessful() {
        return this.type == 6;
    }

    public RRset[] answers() {
        if (this.type != 6) {
            return null;
        }
        List l = (List)this.data;
        return l.toArray(new RRset[0]);
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)((RRset)this.data).first();
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)((RRset)this.data).first();
    }

    public RRset getNS() {
        return (RRset)this.data;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "NXDOMAIN";
            }
            case 2: {
                return "NXRRSET";
            }
            case 3: {
                return "delegation: " + this.data;
            }
            case 4: {
                return "CNAME: " + this.data;
            }
            case 5: {
                return "DNAME: " + this.data;
            }
            case 6: {
                return "successful";
            }
        }
        throw new IllegalStateException();
    }
}

