/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.AccessControlList;
import io.milton.annotations.AddressBooks;
import io.milton.annotations.Authenticate;
import io.milton.annotations.CTag;
import io.milton.annotations.CalendarColor;
import io.milton.annotations.CalendarDateRangeQuery;
import io.milton.annotations.CalendarInvitations;
import io.milton.annotations.CalendarInvitationsCTag;
import io.milton.annotations.CalendarOrder;
import io.milton.annotations.CalendarUserType;
import io.milton.annotations.Calendars;
import io.milton.annotations.ChildOf;
import io.milton.annotations.ChildrenOf;
import io.milton.annotations.ContactData;
import io.milton.annotations.ContentLength;
import io.milton.annotations.ContentType;
import io.milton.annotations.Copy;
import io.milton.annotations.CreatedDate;
import io.milton.annotations.Delete;
import io.milton.annotations.DirectoryGateway;
import io.milton.annotations.Email;
import io.milton.annotations.FreeBusyQuery;
import io.milton.annotations.Get;
import io.milton.annotations.ICalData;
import io.milton.annotations.MakeCollection;
import io.milton.annotations.MaxAge;
import io.milton.annotations.ModifiedDate;
import io.milton.annotations.Move;
import io.milton.annotations.Name;
import io.milton.annotations.Post;
import io.milton.annotations.Principal;
import io.milton.annotations.PrincipalSearch;
import io.milton.annotations.PutChild;
import io.milton.annotations.Realm;
import io.milton.annotations.Root;
import io.milton.annotations.SupportedComponentSets;
import io.milton.annotations.UniqueId;
import io.milton.annotations.Users;
import io.milton.common.Path;
import io.milton.http.Auth;
import io.milton.http.AuthenticationService;
import io.milton.http.HttpManager;
import io.milton.http.LockInfo;
import io.milton.http.LockManager;
import io.milton.http.LockTimeout;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.Response;
import io.milton.http.SecurityManager;
import io.milton.http.annotated.AccessControlListAnnotationHandler;
import io.milton.http.annotated.AddressBooksAnnotationHandler;
import io.milton.http.annotated.AnnoAddressBookResource;
import io.milton.http.annotated.AnnoCalendarHomeResource;
import io.milton.http.annotated.AnnoCalendarResource;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoContactResource;
import io.milton.http.annotated.AnnoEventResource;
import io.milton.http.annotated.AnnoFileResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationHandler;
import io.milton.http.annotated.AuthenticateAnnotationHandler;
import io.milton.http.annotated.CTagAnnotationHandler;
import io.milton.http.annotated.CalendarDateRangeQueryAnnotationHandler;
import io.milton.http.annotated.CalendarInvitationsAnnotationHandler;
import io.milton.http.annotated.CalendarInvitationsCTagAnnotationHandler;
import io.milton.http.annotated.CalendarsAnnotationHandler;
import io.milton.http.annotated.ChildOfAnnotationHandler;
import io.milton.http.annotated.ChildrenOfAnnotationHandler;
import io.milton.http.annotated.CommonPropertyAnnotationHandler;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.ContactDataAnnotationHandler;
import io.milton.http.annotated.ContentTypeAnnotationHandler;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.CopyAnnotationHandler;
import io.milton.http.annotated.DeleteAnnotationHandler;
import io.milton.http.annotated.DisplayNameAnnotationHandler;
import io.milton.http.annotated.DisplayNameSetterAnnotationHandler;
import io.milton.http.annotated.FreeBusyQueryAnnotationHandler;
import io.milton.http.annotated.GetAnnotationHandler;
import io.milton.http.annotated.ICalDataAnnotationHandler;
import io.milton.http.annotated.LockHolder;
import io.milton.http.annotated.LockNullResource;
import io.milton.http.annotated.MakeCalendarAnnotationHandler;
import io.milton.http.annotated.MakeCollectionAnnotationHandler;
import io.milton.http.annotated.MoveAnnotationHandler;
import io.milton.http.annotated.PostAnnotationHandler;
import io.milton.http.annotated.PrincipalSearchAnnotationHandler;
import io.milton.http.annotated.PutChildAnnotationHandler;
import io.milton.http.annotated.RootAnnotationHandler;
import io.milton.http.annotated.UnresolvableParameterException;
import io.milton.http.annotated.UsersAnnotationHandler;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.template.ViewResolver;
import io.milton.http.values.SupportedCalendarComponentListsSet;
import io.milton.http.webdav.DisplayNameFormatter;
import io.milton.resource.CollectionResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(AnnotationResourceFactory.class);
    private AuthenticationService authenticationService;
    private CalendarSearchService calendarSearchService;
    private boolean doEarlyAuth = true;
    private SecurityManager securityManager;
    private LockManager lockManager;
    private String contextPath;
    private Collection<Object> controllers;
    private ViewResolver viewResolver;
    private Map<String, List<LockHolder>> mapOfTempResources = new ConcurrentHashMap<String, List<LockHolder>>();
    private final Map<Class, AnnotationHandler> mapOfAnnotationHandlers = new HashMap<Class, AnnotationHandler>();
    private final Map<Request.Method, AnnotationHandler> mapOfAnnotationHandlersByMethod = new EnumMap<Request.Method, AnnotationHandler>(Request.Method.class);
    final RootAnnotationHandler rootAnnotationHandler = new RootAnnotationHandler(this);
    final GetAnnotationHandler getAnnotationHandler = new GetAnnotationHandler(this);
    final PostAnnotationHandler postAnnotationHandler = new PostAnnotationHandler(this);
    final ChildrenOfAnnotationHandler childrenOfAnnotationHandler = new ChildrenOfAnnotationHandler(this);
    final ChildOfAnnotationHandler childOfAnnotationHandler = new ChildOfAnnotationHandler(this);
    final DisplayNameAnnotationHandler displayNameAnnotationHandler = new DisplayNameAnnotationHandler(this);
    final DisplayNameSetterAnnotationHandler displayNameSetterAnnotationHandler = new DisplayNameSetterAnnotationHandler(this);
    final MakeCollectionAnnotationHandler makCollectionAnnotationHandler = new MakeCollectionAnnotationHandler(this);
    final MakeCalendarAnnotationHandler makeCalendarAnnotationHandler = new MakeCalendarAnnotationHandler(this);
    final MoveAnnotationHandler moveAnnotationHandler = new MoveAnnotationHandler(this);
    final DeleteAnnotationHandler deleteAnnotationHandler = new DeleteAnnotationHandler(this);
    final CopyAnnotationHandler copyAnnotationHandler = new CopyAnnotationHandler(this);
    final PutChildAnnotationHandler putChildAnnotationHandler = new PutChildAnnotationHandler(this);
    final UsersAnnotationHandler usersAnnotationHandler = new UsersAnnotationHandler(this);
    final AuthenticateAnnotationHandler authenticateAnnotationHandler = new AuthenticateAnnotationHandler(this);
    final AccessControlListAnnotationHandler accessControlListAnnotationHandler = new AccessControlListAnnotationHandler(this);
    final CTagAnnotationHandler cTagAnnotationHandler = new CTagAnnotationHandler(this);
    final ICalDataAnnotationHandler iCalDataAnnotationHandler = new ICalDataAnnotationHandler(this);
    final CalendarsAnnotationHandler calendarsAnnotationHandler = new CalendarsAnnotationHandler(this);
    final AddressBooksAnnotationHandler addressBooksAnnotationHandler = new AddressBooksAnnotationHandler(this);
    final ContactDataAnnotationHandler contactDataAnnotationHandler = new ContactDataAnnotationHandler(this);
    final PrincipalSearchAnnotationHandler principalSearchAnnotationHandler = new PrincipalSearchAnnotationHandler(this);
    final CommonPropertyAnnotationHandler<String> nameAnnotationHandler = new CommonPropertyAnnotationHandler(Name.class, this, "name", "fileName");
    final CommonPropertyAnnotationHandler<String> emailAnnotationHandler = new CommonPropertyAnnotationHandler(Email.class, this, "email");
    final CommonPropertyAnnotationHandler<SupportedCalendarComponentListsSet> supportedComponentSets = new CommonPropertyAnnotationHandler(SupportedComponentSets.class, this, "supportedComponentSets");
    final CommonPropertyAnnotationHandler<String> realmAnnotationHandler = new CommonPropertyAnnotationHandler(Realm.class, this, "realm");
    final CommonPropertyAnnotationHandler<Date> modifiedDateAnnotationHandler = new CommonPropertyAnnotationHandler(ModifiedDate.class, this, "modifiedDate");
    final CommonPropertyAnnotationHandler<Date> createdDateAnnotationHandler = new CommonPropertyAnnotationHandler(CreatedDate.class, this);
    final ContentTypeAnnotationHandler contentTypeAnnotationHandler = new ContentTypeAnnotationHandler(this, "contentType");
    final CommonPropertyAnnotationHandler<Long> contentLengthAnnotationHandler = new CommonPropertyAnnotationHandler(ContentLength.class, this, "contentLength");
    final CommonPropertyAnnotationHandler<Long> maxAgeAnnotationHandler = new CommonPropertyAnnotationHandler(MaxAge.class, this, "maxAge");
    final CommonPropertyAnnotationHandler<String> uniqueIdAnnotationHandler = new CommonPropertyAnnotationHandler(UniqueId.class, this, "id");
    final CommonPropertyAnnotationHandler<String> calendarColorAnnotationHandler = new CommonPropertyAnnotationHandler(CalendarColor.class, this, "color");
    final CommonPropertyAnnotationHandler<String> calendarOrderAnnotationHandler = new CommonPropertyAnnotationHandler(CalendarOrder.class, this, "order");
    final CommonPropertyAnnotationHandler<String> calendarUserTypeAnnotationHandler = new CommonPropertyAnnotationHandler(CalendarUserType.class, this, "calendarUserType", "cuType");
    final CalendarDateRangeQueryAnnotationHandler calendarDateRangeQueryAnnotationHandler = new CalendarDateRangeQueryAnnotationHandler(this);
    final FreeBusyQueryAnnotationHandler freeBusyQueryAnnotationHandler = new FreeBusyQueryAnnotationHandler(this);
    final CalendarInvitationsAnnotationHandler calendarInvitationsAnnotationHandler = new CalendarInvitationsAnnotationHandler(this);
    final CalendarInvitationsCTagAnnotationHandler calendarInvitationsCTagAnnotationHandler = new CalendarInvitationsCTagAnnotationHandler(this);
    final CommonPropertyAnnotationHandler<Boolean> directoryGatewayAnnotationHandler = new CommonPropertyAnnotationHandler(DirectoryGateway.class, this, "directoryGateway");

    public AnnotationResourceFactory() {
        this.supportedComponentSets.setDefaultValue(SupportedCalendarComponentListsSet.EVENTS_ONLY);
        this.mapOfAnnotationHandlers.put(Root.class, this.rootAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Get.class, this.getAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Post.class, this.postAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ChildrenOf.class, this.childrenOfAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ChildOf.class, this.childOfAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Name.class, this.nameAnnotationHandler);
        this.mapOfAnnotationHandlers.put(DisplayNameAnnotationHandler.class, this.displayNameAnnotationHandler);
        this.mapOfAnnotationHandlers.put(DisplayNameSetterAnnotationHandler.class, this.displayNameSetterAnnotationHandler);
        this.mapOfAnnotationHandlers.put(MakeCollection.class, this.makCollectionAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Move.class, this.moveAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Delete.class, this.deleteAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Copy.class, this.copyAnnotationHandler);
        this.mapOfAnnotationHandlers.put(PutChild.class, this.putChildAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Users.class, this.usersAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Authenticate.class, this.authenticateAnnotationHandler);
        this.mapOfAnnotationHandlers.put(AccessControlList.class, this.accessControlListAnnotationHandler);
        this.mapOfAnnotationHandlers.put(AddressBooks.class, this.addressBooksAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Calendars.class, this.calendarsAnnotationHandler);
        this.mapOfAnnotationHandlers.put(MakeCalendarAnnotationHandler.class, this.makeCalendarAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ModifiedDate.class, this.modifiedDateAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CreatedDate.class, this.createdDateAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ContentType.class, this.contentTypeAnnotationHandler);
        this.mapOfAnnotationHandlers.put(MaxAge.class, this.maxAgeAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ContentLength.class, this.contentLengthAnnotationHandler);
        this.mapOfAnnotationHandlers.put(UniqueId.class, this.uniqueIdAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CTag.class, this.cTagAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ICalData.class, this.iCalDataAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarColor.class, this.calendarColorAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarOrder.class, this.calendarOrderAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarUserType.class, this.calendarUserTypeAnnotationHandler);
        this.mapOfAnnotationHandlers.put(ContactData.class, this.contactDataAnnotationHandler);
        this.mapOfAnnotationHandlers.put(PrincipalSearch.class, this.principalSearchAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarDateRangeQuery.class, this.calendarDateRangeQueryAnnotationHandler);
        this.mapOfAnnotationHandlers.put(FreeBusyQuery.class, this.freeBusyQueryAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarInvitations.class, this.calendarInvitationsAnnotationHandler);
        this.mapOfAnnotationHandlers.put(CalendarInvitationsCTag.class, this.calendarInvitationsCTagAnnotationHandler);
        this.mapOfAnnotationHandlers.put(Email.class, this.emailAnnotationHandler);
        this.mapOfAnnotationHandlers.put(SupportedComponentSets.class, this.supportedComponentSets);
        for (AnnotationHandler ah : this.mapOfAnnotationHandlers.values()) {
            Request.Method[] methods = ah.getSupportedMethods();
            if (methods == null) continue;
            for (Request.Method m : methods) {
                this.mapOfAnnotationHandlersByMethod.put(m, ah);
            }
        }
    }

    public Resource getResource(String host, String url) throws NotAuthorizedException, BadRequestException {
        AnnoCollectionResource r;
        AnnoCollectionResource hostRoot;
        if (log.isTraceEnabled()) {
            log.trace("getResource: host: " + host + " - url:" + url);
        }
        if ((hostRoot = this.locateHostRoot(host, HttpManager.request())) == null) {
            if (this.rootAnnotationHandler.getControllerMethods().isEmpty()) {
                log.warn("No @Root methods were found, so i cant find a root resource. Note that controller methods are displayed on startup");
            } else {
                log.warn("Could not find a root resource for host: " + host + " Using " + this.rootAnnotationHandler.getControllerMethods().size() + " root methods");
            }
            return null;
        }
        if ((url = this.stripContext(url)).equals("/") || url.isEmpty()) {
            r = hostRoot;
        } else {
            Path path = Path.path((String)url);
            r = this.findFromRoot(hostRoot, path);
            if (log.isTraceEnabled()) {
                if (r == null) {
                    log.trace("Resource not found: host=" + host + " path=" + path);
                } else if (r instanceof AnnoResource) {
                    AnnoResource ar = r;
                    log.trace("Found AnnoResource: " + r.getClass() + "  for path=" + path + "  with source: " + ar.getSource());
                } else {
                    log.trace("Found resource: " + r.getClass() + "  for path=" + path);
                }
            }
        }
        return r;
    }

    public Resource findFromRoot(AnnoCollectionResource rootFolder, Path p) throws NotAuthorizedException, BadRequestException {
        AnnoCollectionResource col = rootFolder;
        Resource r = null;
        for (String s : p.getParts()) {
            if (col == null) {
                if (log.isTraceEnabled()) {
                    log.trace("findFromRoot: collection is null, can't look for child: " + s);
                }
                return null;
            }
            r = col.child(s);
            if (r == null) {
                if (log.isTraceEnabled()) {
                    log.trace("findFromRoot: Couldnt find child: " + s + " of parent: " + col.getName() + " with type: " + col.getClass());
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                if (r instanceof AnnoResource) {
                    AnnoResource ar = (AnnoResource)r;
                    log.trace("findFromRoot: found a child: " + r.getName() + " with source type: " + ar.getSource().getClass());
                } else {
                    log.trace("findFromRoot: found a child: " + r.getName() + " of type: " + r.getClass());
                }
            }
            col = r instanceof CollectionResource ? (CollectionResource)r : null;
        }
        return r;
    }

    public String getRealm(String host) {
        return this.securityManager.getRealm(host);
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public CalendarSearchService getCalendarSearchService() {
        return this.calendarSearchService;
    }

    public void setCalendarSearchService(CalendarSearchService calendarSearchService) {
        this.calendarSearchService = calendarSearchService;
    }

    public boolean isDoEarlyAuth() {
        return this.doEarlyAuth;
    }

    public void setDoEarlyAuth(boolean doEarlyAuth) {
        this.doEarlyAuth = doEarlyAuth;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        if (securityManager != null) {
            log.debug("securityManager: " + securityManager.getClass());
        } else {
            log.warn("Setting null FsSecurityManager. This WILL cause null pointer exceptions");
        }
        this.securityManager = securityManager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setMaxAgeSeconds(Long maxAgeSeconds) {
        this.maxAgeAnnotationHandler.setDefaultValue(maxAgeSeconds);
    }

    public Long getMaxAgeSeconds() {
        return this.maxAgeAnnotationHandler.getDefaultValue();
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getValidContextPath() {
        String s = this.getContextPath();
        if (s == null || s.isEmpty()) {
            return "/";
        }
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    public String stripContext(String url) {
        if (this.contextPath != null && this.contextPath.length() > 0 && !this.contextPath.equals("/")) {
            String c = !this.contextPath.startsWith("/") ? "/" + this.contextPath : this.contextPath;
            url = url.replaceFirst(c, "");
        }
        return url;
    }

    public Collection<Object> getControllers() {
        return this.controllers;
    }

    public void setControllers(Collection<Object> controllers) {
        this.controllers = Collections.unmodifiableCollection(controllers);
        log.info("setControllers: " + controllers.size() + " parsing controllers...");
        for (Object controller : controllers) {
            log.info("Parse controller: " + controller.getClass());
            for (AnnotationHandler ah : this.mapOfAnnotationHandlers.values()) {
                log.info(" - controller: " + controller.getClass() + " handler: " + ah.getAnnoClass());
                ah.parseController(controller);
            }
        }
        log.info("Controller parsing complete. Listing found methods..");
        for (AnnotationHandler ah : this.mapOfAnnotationHandlers.values()) {
            log.info("Annotation: " + ah.getAnnoClass());
            List<ControllerMethod> list = ah.getControllerMethods();
            if (list == null || list.isEmpty()) {
                log.info("  No methods found");
                continue;
            }
            for (ControllerMethod cm : ah.getControllerMethods()) {
                log.info("  method: " + cm.method);
            }
        }
    }

    public ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    private AnnoCollectionResource locateHostRoot(String host, Request request) {
        AnnoCollectionResource rootRes;
        if (request != null && (rootRes = (AnnoCollectionResource)request.getAttributes().get("RootRes_" + host)) != null) {
            return rootRes;
        }
        Object root = this.rootAnnotationHandler.execute(host);
        if (root == null) {
            return null;
        }
        rootRes = new AnnoCollectionResource(this, root, null);
        if (request != null) {
            request.getAttributes().put("RootRes_" + host, rootRes);
        }
        return rootRes;
    }

    public boolean isCompatible(Object source, Request.Method m) {
        if (this.in(m, Request.Method.REPORT, Request.Method.LOCK, Request.Method.UNLOCK, Request.Method.HEAD, Request.Method.OPTIONS, Request.Method.PROPPATCH, Request.Method.ACL)) {
            return true;
        }
        AnnotationHandler ah = this.mapOfAnnotationHandlersByMethod.get(m);
        if (ah != null) {
            boolean b = ah.isCompatible(source);
            if (log.isTraceEnabled()) {
                log.trace("isCompatible: " + source + " - " + m + " = " + b);
            }
            return b;
        }
        log.warn("No annotation handler is configured for http method: " + m);
        return false;
    }

    public Object[] buildInvokeArgs(AnnoResource sourceRes, Method m, Object ... otherValues) throws Exception {
        return this.buildInvokeArgsExt(sourceRes, null, false, m, otherValues);
    }

    public Object[] buildInvokeArgsExt(AnnoResource sourceRes, Object mandatorySecondArg, boolean forceUseSecondArg, Method m, Object ... otherValues) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("buildInvokeArgsExt: source=" + sourceRes.getSource() + " on method: " + m);
        }
        Request request = HttpManager.request();
        Response response = HttpManager.response();
        Auth auth = request.getAuthorization();
        AnnoPrincipalResource principal = null;
        if (auth != null && auth.getTag() instanceof AnnoPrincipalResource) {
            principal = (AnnoPrincipalResource)auth.getTag();
        }
        Object[] args = new Object[m.getParameterTypes().length];
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(sourceRes.getSource());
        for (Object s : otherValues) {
            list.add(s);
            if (!(s instanceof AnnoResource)) continue;
            AnnoResource otherRes = (AnnoResource)s;
            list.add(otherRes.getSource());
        }
        for (AnnoCollectionResource r = sourceRes.getParent(); r != null; r = r.getParent()) {
            list.add(r.getSource());
            list.add(r);
        }
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            Object argValue;
            if (i == 1 && forceUseSecondArg) {
                args[i] = mandatorySecondArg;
                continue;
            }
            if (this.isPrincipalArg(m, i)) {
                if ((principal = this.checkAuthentication(sourceRes, principal)) != null) {
                    args[i] = principal.source;
                    continue;
                }
                log.warn("Null principal provided for method: " + m);
                args[i] = null;
                continue;
            }
            Class<?> type = m.getParameterTypes()[i];
            try {
                argValue = this.findArgValue(type, request, response, list);
            }
            catch (UnresolvableParameterException e) {
                log.warn("Could not resolve parameter: " + i + "  in method: " + m.getName());
                argValue = null;
            }
            args[i] = argValue;
        }
        return args;
    }

    public Method findMethodForAnno(Class sourceClass, Class annoClass) {
        for (Method m : sourceClass.getMethods()) {
            Object a = m.getAnnotation(annoClass);
            if (a == null) continue;
            return m;
        }
        return null;
    }

    private Object findArgValue(Class type, Request request, Response response, List otherAvailValues) throws Exception {
        if (type == Request.class) {
            return request;
        }
        if (type == Response.class) {
            return response;
        }
        if (type == byte[].class) {
            InputStream in = (InputStream)this.findArgValue(InputStream.class, request, response, otherAvailValues);
            return this.toBytes(in);
        }
        for (Object o : otherAvailValues) {
            if (o == null || !type.isAssignableFrom(o.getClass())) continue;
            otherAvailValues.remove(o);
            return o;
        }
        if (log.isInfoEnabled()) {
            if (log.isDebugEnabled()) {
                log.info("Unknown parameter type: " + type);
                log.debug("Available types are:");
                log.debug(" - " + Request.class);
                log.debug(" - " + Response.class);
                for (Object o : otherAvailValues) {
                    if (o != null) {
                        log.debug(" - " + o.getClass());
                        continue;
                    }
                    log.debug(" - null");
                }
            } else {
                log.info("Unknown parameter type: " + type + " Enable DEBUG level logging to see available objects");
            }
        }
        throw new UnresolvableParameterException("Couldnt find parameter of type: " + type);
    }

    private byte[] toBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)bout);
        return bout.toByteArray();
    }

    public AnnoResource instantiate(Object childSource, AnnoCollectionResource parent, Method m) {
        if (this.authenticateAnnotationHandler.canAuthenticate(childSource)) {
            return new AnnoPrincipalResource(this, childSource, parent);
        }
        if (parent instanceof AnnoPrincipalResource && this.calendarsAnnotationHandler.isCompatible(childSource)) {
            AnnoPrincipalResource p = (AnnoPrincipalResource)parent;
            return new AnnoCalendarHomeResource(this, childSource, p, this.calendarSearchService);
        }
        if (m.getAnnotation(Calendars.class) != null) {
            return new AnnoCalendarResource(this, childSource, parent);
        }
        if (parent instanceof AnnoCalendarResource) {
            if (this.childrenOfAnnotationHandler.isCompatible(childSource) || this.childOfAnnotationHandler.isCompatible(childSource)) {
                return new AnnoCollectionResource(this, childSource, parent);
            }
            return new AnnoEventResource(this, childSource, parent);
        }
        if (m.getAnnotation(AddressBooks.class) != null) {
            return new AnnoAddressBookResource(this, childSource, parent);
        }
        if (parent instanceof AnnoAddressBookResource) {
            return new AnnoContactResource(this, childSource, parent);
        }
        if (this.childrenOfAnnotationHandler.isCompatible(childSource) || this.childOfAnnotationHandler.isCompatible(childSource)) {
            return new AnnoCollectionResource(this, childSource, parent);
        }
        return new AnnoFileResource(this, childSource, parent);
    }

    public CommonResource instantiate(LockHolder r, AnnoCollectionResource parent) {
        return new LockNullResource(this, parent, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHolder createLockHolder(AnnoCollectionResource parentCollection, String name, LockTimeout timeout, LockInfo lockInfo) {
        String parentKey = parentCollection.getUniqueId();
        if (parentKey == null) {
            throw new RuntimeException("Cant create temp resource because parent's uniqueID is null. Please add the @UniqueID for class: " + parentCollection.getSource().getClass());
        }
        LockHolder r = new LockHolder(UUID.randomUUID());
        r.setParentCollectionId(parentKey);
        r.setName(name);
        r.setLockTimeout(timeout);
        r.setLockInfo(lockInfo);
        AnnotationResourceFactory annotationResourceFactory = this;
        synchronized (annotationResourceFactory) {
            List<LockHolder> list = this.mapOfTempResources.get(parentKey);
            if (list == null) {
                list = new CopyOnWriteArrayList<LockHolder>();
                this.mapOfTempResources.put(parentKey, list);
            }
            list.add(r);
        }
        return r;
    }

    public List<LockHolder> getTempResourcesForParent(AnnoCollectionResource parent) {
        String parentKey = parent.getUniqueId();
        if (parentKey == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getTempResourcesForParent(parentKey);
    }

    public List<LockHolder> getTempResourcesForParent(String parentKey) {
        List<LockHolder> list = this.mapOfTempResources.get(parentKey);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public void removeLockHolder(AnnoCollectionResource parent, String name) {
        List<LockHolder> list = this.getTempResourcesForParent(parent);
        Iterator<LockHolder> it = list.iterator();
        ArrayList<LockHolder> toRemove = new ArrayList<LockHolder>();
        while (it.hasNext()) {
            LockHolder o = it.next();
            if (!o.getName().equals(name)) continue;
            toRemove.add(o);
        }
        list.removeAll(toRemove);
        parent.removeLockHolder(name);
    }

    public Map<String, List<LockHolder>> getMapOfTempResources() {
        return this.mapOfTempResources;
    }

    public void setMapOfTempResources(Map<String, List<LockHolder>> mapOfTempResources) {
        this.mapOfTempResources = mapOfTempResources;
    }

    private boolean in(Request.Method m, Request.Method ... methods) {
        for (Request.Method listMethod : methods) {
            if (!m.equals((Object)listMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrincipalArg(Method m, int i) {
        Annotation[] arr = m.getParameterAnnotations()[i];
        Class<Principal> annoType = Principal.class;
        for (Annotation a : arr) {
            if (!a.annotationType().equals(annoType)) continue;
            return true;
        }
        return false;
    }

    public void createAndAppend(Collection<AnnoResource> result, Object sources, AnnoCollectionResource parent, ControllerMethod cm) {
        if (sources != null) {
            if (sources instanceof Collection) {
                Collection l = (Collection)sources;
                for (Object item : l) {
                    result.add(this.instantiate(item, parent, cm.method));
                }
            } else if (sources.getClass().isArray()) {
                Object[] arr;
                for (Object item : arr = (Object[])sources) {
                    result.add(this.instantiate(item, parent, cm.method));
                }
            } else {
                result.add(this.instantiate(sources, parent, cm.method));
            }
        }
    }

    private AnnoPrincipalResource checkAuthentication(AnnoResource res, AnnoPrincipalResource principal) throws NotAuthorizedException {
        if (principal != null) {
            return principal;
        }
        if (this.doEarlyAuth && this.authenticationService != null) {
            Request request = HttpManager.request();
            AuthenticationService.AuthStatus authStatus = this.authenticationService.authenticate(res, request);
            if (authStatus == null) {
                log.trace("Authentication not attempted");
                throw new NotAuthorizedException((Resource)res);
            }
            if (authStatus.loginFailed) {
                log.warn("Early authentication failed");
                throw new NotAuthorizedException((Resource)res);
            }
            log.trace("Early authentication succeeded");
            Auth auth = authStatus.auth;
            if (auth != null && auth.getTag() instanceof AnnoPrincipalResource) {
                principal = (AnnoPrincipalResource)auth.getTag();
            }
            return principal;
        }
        return null;
    }

    public CalendarDateRangeQueryAnnotationHandler getCalendarDateRangeQueryAnnotationHandler() {
        return this.calendarDateRangeQueryAnnotationHandler;
    }

    public CalendarInvitationsAnnotationHandler getCalendarInvitationsAnnotationHandler() {
        return this.calendarInvitationsAnnotationHandler;
    }

    public CalendarInvitationsCTagAnnotationHandler getCalendarInvitationsCTagAnnotationHandler() {
        return this.calendarInvitationsCTagAnnotationHandler;
    }

    public FreeBusyQueryAnnotationHandler getFreeBusyQueryAnnotationHandler() {
        return this.freeBusyQueryAnnotationHandler;
    }

    public UsersAnnotationHandler getUsersAnnotationHandler() {
        return this.usersAnnotationHandler;
    }

    public static class AnnotationsDisplayNameFormatter
    implements DisplayNameFormatter {
        private final DisplayNameFormatter wrapped;

        public AnnotationsDisplayNameFormatter(DisplayNameFormatter wrapper) {
            this.wrapped = wrapper;
        }

        @Override
        public String formatDisplayName(PropFindableResource res) {
            if (res instanceof AnnoResource) {
                AnnoResource r = (AnnoResource)res;
                return r.getDisplayName();
            }
            return this.wrapped.formatDisplayName(res);
        }
    }
}

