/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.common.ContentTypeUtils;
import io.milton.common.LogUtils;
import io.milton.common.Path;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.resource.CollectionResource;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutHelper {
    private static final Logger log = LoggerFactory.getLogger(PutHelper.class);

    public Range parseContentRange(Resource r, Request request) throws IOException, BadRequestException {
        long finish;
        long start;
        String rangeHeader = request.getContentRangeHeader();
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            log.warn("Invalid range header, does not start with 'bytes': " + rangeHeader);
            throw new BadRequestException(r);
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            log.warn("Invalid range header, dash not found: " + rangeHeader);
            throw new BadRequestException(r);
        }
        if (slashPos == -1) {
            log.warn("Invalid range header, slash not found: " + rangeHeader);
            throw new BadRequestException(r);
        }
        String s = rangeHeader.substring(0, dashPos);
        try {
            start = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid range header, start is not a valid number: " + s + " Raw header:" + rangeHeader);
            throw new BadRequestException(r);
        }
        s = rangeHeader.substring(dashPos + 1, slashPos);
        try {
            finish = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid range header, finish is not a valid number: " + s + " Raw header:" + rangeHeader);
            throw new BadRequestException(r);
        }
        Range range = new Range(Long.valueOf(start), Long.valueOf(finish));
        if (!this.validate(range)) {
            throw new BadRequestException(r);
        }
        return range;
    }

    private boolean validate(Range r) {
        if (r.getStart() < 0L) {
            log.warn("invalid range, start is negative");
            return false;
        }
        if (r.getFinish() < 0L) {
            log.warn("invalid range, finish is negative");
            return false;
        }
        if (r.getStart() > r.getFinish()) {
            log.warn("invalid range, start is greater then finish");
            return false;
        }
        return true;
    }

    public Long getContentLength(Request request) throws BadRequestException {
        String s;
        Long l = request.getContentLengthHeader();
        if (l == null && (s = request.getRequestHeader(Request.Header.X_EXPECTED_ENTITY_LENGTH)) != null && s.length() > 0) {
            log.debug("no content-length given, but founhd non-standard length header: " + s);
            try {
                l = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException(null, "invalid length for header: " + Request.Header.X_EXPECTED_ENTITY_LENGTH.code + ". value is: " + s);
            }
        }
        return l;
    }

    public String findContentTypes(Request request, String newName) {
        String s = ContentTypeUtils.findContentTypes((String)newName);
        LogUtils.trace((Logger)log, (Object[])new Object[]{"findContentTypes: got type from name. Type: " + s});
        return s;
    }

    public CollectionResource findNearestParent(HttpManager manager, String host, Path path) throws NotAuthorizedException, ConflictException, BadRequestException {
        if (path == null) {
            return null;
        }
        Resource thisResource = manager.getResourceFactory().getResource(host, path.toString());
        if (thisResource != null) {
            if (thisResource instanceof CollectionResource) {
                return (CollectionResource)thisResource;
            }
            log.warn("parent is not a collection: " + path);
            return null;
        }
        return this.findNearestParent(manager, host, path.getParent());
    }

    public void applyPartialUpdate(GetableResource replacee, Request request, Range range, OutputStream tempOut) throws NotAuthorizedException, BadRequestException, NotFoundException {
        try {
            replacee.sendContent(tempOut, null, null, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

