/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.common.StreamUtils;
import io.milton.http.webdav.PropFindRequestFieldParser;
import io.milton.http.webdav.PropFindSaxHandler;
import io.milton.http.webdav.PropertiesRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultPropFindRequestFieldParser
implements PropFindRequestFieldParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropFindRequestFieldParser.class);

    @Override
    public PropertiesRequest getRequestedFields(InputStream in) {
        LinkedHashSet<QName> set = new LinkedHashSet<QName>();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamUtils.readTo((InputStream)in, (OutputStream)bout, (boolean)false, (boolean)true);
            byte[] arr = bout.toByteArray();
            if (arr.length > 1) {
                ByteArrayInputStream bin = new ByteArrayInputStream(arr);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                PropFindSaxHandler handler = new PropFindSaxHandler();
                reader.setContentHandler(handler);
                try {
                    reader.parse(new InputSource(bin));
                    if (handler.isAllProp()) {
                        return new PropertiesRequest();
                    }
                    set.addAll(handler.getAttributes().keySet());
                }
                catch (IOException | SAXException e) {
                    log.warn("exception parsing request body", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            log.warn("Exception parsing PROPFIND request fields. Returning empty property set", (Throwable)ex);
        }
        return PropertiesRequest.toProperties(set);
    }
}

