/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropPatchSaxHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(PropPatchSaxHandler.class);
    private static final QName SET = new QName("DAV:", "set");
    private static final QName REMOVE = new QName("DAV:", "remove");
    private static final QName PROP = new QName("DAV:", "prop");
    private final Stack<StateHandler> handlers = new Stack();
    private final Map<QName, String> attributesSet = new LinkedHashMap<QName, String>();
    private final Map<QName, String> attributesRemove = new LinkedHashMap<QName, String>();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        QName qname = new QName(uri, localName);
        StateHandler handler = !this.handlers.isEmpty() ? this.handlers.peek().startChild(qname, attributes) : new Root(this.attributesSet, this.attributesRemove);
        this.handlers.push(handler);
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handlers.peek().characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        QName qname = new QName(uri, localName);
        StateHandler handler = this.handlers.pop();
        handler.endSelf(qname);
        super.endElement(uri, localName, name);
    }

    public Map<QName, String> getAttributesToSet() {
        return this.attributesSet;
    }

    public Map<QName, String> getAttributesToRemove() {
        return this.attributesRemove;
    }

    private static class Content
    extends StateHandler {
        private final StringBuilder value = new StringBuilder();

        private Content() {
        }

        @Override
        public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
            this.value.append("<").append(name.getLocalPart());
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.value.append(" ");
                    this.value.append(attributes.getLocalName(i));
                    this.value.append("=\"");
                    this.value.append(attributes.getValue(i));
                    this.value.append("\"");
                }
            }
            this.value.append(">");
            return this;
        }

        @Override
        public void endSelf(QName name) throws SAXException {
            if (this.value.charAt(this.value.length() - 1) == '>') {
                this.value.insert(this.value.length() - 1, '/');
            } else {
                this.value.append("</").append(name.getLocalPart()).append(">");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.value.append(new String(ch, start, length));
        }

        public String getValue() {
            return this.value.toString();
        }
    }

    private static class Attribute
    extends StateHandler {
        private final Map<QName, String> values;
        private final Content content = new Content();

        private Attribute(Map<QName, String> values) {
            this.values = values;
        }

        @Override
        public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
            this.content.startChild(name, attributes);
            return this.content;
        }

        @Override
        public void endSelf(QName name) throws SAXException {
            this.values.put(name, this.content.getValue().trim());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content.characters(ch, start, length);
        }
    }

    private static class Prop
    extends StateHandler {
        private final Map<QName, String> values;

        private Prop(Map<QName, String> values) {
            this.values = values;
        }

        @Override
        public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
            return new Attribute(this.values);
        }
    }

    private static class Op
    extends StateHandler {
        private final Map<QName, String> values;

        private Op(Map<QName, String> values) {
            this.values = values;
        }

        @Override
        public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
            if (name.equals(PROP)) {
                return new Prop(this.values);
            }
            return StateHandler.Ignore;
        }
    }

    private static class Root
    extends StateHandler {
        private final Map<QName, String> set;
        private final Map<QName, String> remove;

        private Root(Map<QName, String> set, Map<QName, String> remove) {
            this.set = set;
            this.remove = remove;
        }

        @Override
        public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
            if (name.equals(SET)) {
                return new Op(this.set);
            }
            if (name.equals(REMOVE)) {
                return new Op(this.remove);
            }
            return StateHandler.Ignore;
        }
    }

    private static abstract class StateHandler {
        public static final StateHandler Ignore = new StateHandler(){

            @Override
            public StateHandler startChild(QName name, Attributes attributes) throws SAXException {
                return this;
            }
        };

        private StateHandler() {
        }

        public abstract StateHandler startChild(QName var1, Attributes var2) throws SAXException;

        public void endSelf(QName name) throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }
    }
}

