/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DClass;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.Header;
import io.milton.dns.record.OPTRecord;
import io.milton.dns.record.RRset;
import io.milton.dns.record.Record;
import io.milton.dns.record.SIGRecord;
import io.milton.dns.record.Section;
import io.milton.dns.record.TSIG;
import io.milton.dns.record.TSIGRecord;
import io.milton.dns.record.Type;
import io.milton.dns.record.Update;
import io.milton.dns.record.WireParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    private Header header;
    private final List[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;
    public int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static final Record[] emptyRecordArray = new Record[0];
    private static final RRset[] emptyRRsetArray = new RRset[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int id) {
        this(new Header(id));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record r) {
        Message m = new Message();
        m.header.setOpcode(0);
        m.header.setFlag(7);
        m.addRecord(r, 0);
        return m;
    }

    public static Message newUpdate(Name zone) {
        return new Update(zone);
    }

    Message(DNSInput in) throws IOException {
        block6: {
            this(new Header(in));
            boolean isUpdate = this.header.getOpcode() == 5;
            boolean truncated = this.header.getFlag(6);
            try {
                for (int i = 0; i < 4; ++i) {
                    int count = this.header.getCount(i);
                    if (count > 0) {
                        this.sections[i] = new ArrayList(count);
                    }
                    for (int j = 0; j < count; ++j) {
                        int pos = in.current();
                        Record rec = Record.fromWire(in, i, isUpdate);
                        this.sections[i].add(rec);
                        if (rec.getType() == 250) {
                            this.tsigstart = pos;
                        }
                        if (rec.getType() != 24 || ((SIGRecord)rec).getTypeCovered() != 0) continue;
                        this.sig0start = pos;
                    }
                }
            }
            catch (WireParseException e) {
                if (truncated) break block6;
                throw e;
            }
        }
        this.size = in.current();
    }

    public Message(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    public void setHeader(Header h) {
        this.header = h;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record r, int section) {
        if (this.sections[section] == null) {
            this.sections[section] = new LinkedList();
        }
        this.header.incCount(section);
        this.sections[section].add(r);
    }

    public boolean removeRecord(Record r, int section) {
        if (this.sections[section] != null && this.sections[section].remove(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        this.sections[section] = null;
        this.header.setCount(section, 0);
    }

    public boolean findRecord(Record r, int section) {
        return this.sections[section] != null && this.sections[section].contains(r);
    }

    public boolean findRecord(Record r) {
        for (int i = 1; i <= 3; ++i) {
            if (this.sections[i] == null || !this.sections[i].contains(r)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type, int section) {
        if (this.sections[section] == null) {
            return false;
        }
        for (int i = 0; i < this.sections[section].size(); ++i) {
            Record r = (Record)this.sections[section].get(i);
            if (r.getType() != type || !name.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public Record getQuestion() {
        List l = this.sections[0];
        if (l == null || l.isEmpty()) {
            return null;
        }
        return (Record)l.get(0);
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        List l = this.sections[3];
        Record rec = (Record)l.get(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        Record[] additional;
        for (Record record : additional = this.getSectionArray(3)) {
            if (!(record instanceof OPTRecord)) continue;
            return (OPTRecord)record;
        }
        return null;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode += opt.getExtendedRcode() << 4;
        }
        return rcode;
    }

    public Record[] getSectionArray(int section) {
        if (this.sections[section] == null) {
            return emptyRecordArray;
        }
        List l = this.sections[section];
        return l.toArray(new Record[0]);
    }

    private static boolean sameSet(Record r1, Record r2) {
        return r1.getRRsetType() == r2.getRRsetType() && r1.getDClass() == r2.getDClass() && r1.getName().equals(r2.getName());
    }

    public RRset[] getSectionRRsets(int section) {
        if (this.sections[section] == null) {
            return emptyRRsetArray;
        }
        LinkedList<RRset> sets = new LinkedList<RRset>();
        Record[] recs = this.getSectionArray(section);
        HashSet<Name> hash = new HashSet<Name>();
        for (Record rec : recs) {
            Name name = rec.getName();
            boolean newset = true;
            if (hash.contains(name)) {
                for (int j = sets.size() - 1; j >= 0; --j) {
                    RRset set = (RRset)sets.get(j);
                    if (set.getType() != rec.getRRsetType() || set.getDClass() != rec.getDClass() || !set.getName().equals(name)) continue;
                    set.addRR(rec);
                    newset = false;
                    break;
                }
            }
            if (!newset) continue;
            RRset set = new RRset(rec);
            sets.add(set);
            hash.add(name);
        }
        return sets.toArray(new RRset[0]);
    }

    public void toWire(DNSOutput out) {
        this.header.toWire(out);
        Compression c = new Compression();
        for (int i = 0; i < 4; ++i) {
            if (this.sections[i] == null) continue;
            for (int j = 0; j < this.sections[i].size(); ++j) {
                Record rec = (Record)this.sections[i].get(j);
                rec.toWire(out, i, c);
            }
        }
    }

    private int sectionToWire(DNSOutput out, int section, Compression c, int maxLength) {
        int n = this.sections[section].size();
        int pos = out.current();
        int rendered = 0;
        Record lastrec = null;
        for (int i = 0; i < n; ++i) {
            Record rec = (Record)this.sections[section].get(i);
            if (lastrec != null && !Message.sameSet(rec, lastrec)) {
                pos = out.current();
                rendered = i;
            }
            lastrec = rec;
            rec.toWire(out, section, c);
            if (out.current() <= maxLength) continue;
            out.jump(pos);
            return n - rendered;
        }
        return 0;
    }

    private boolean toWire(DNSOutput out, int maxLength) {
        if (maxLength < 12) {
            return false;
        }
        Header newheader = null;
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        int startpos = out.current();
        this.header.toWire(out);
        Compression c = new Compression();
        for (int i = 0; i < 4; ++i) {
            int skipped;
            if (this.sections[i] == null || (skipped = this.sectionToWire(out, i, c, tempMaxLength)) == 0) continue;
            if (newheader == null) {
                newheader = (Header)this.header.clone();
            }
            if (i != 3) {
                newheader.setFlag(6);
            }
            int count = newheader.getCount(i);
            newheader.setCount(i, count - skipped);
            for (int j = i + 1; j < 4; ++j) {
                newheader.setCount(j, 0);
            }
            out.save();
            out.jump(startpos);
            newheader.toWire(out);
            out.restore();
            break;
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            if (newheader == null) {
                newheader = (Header)this.header.clone();
            }
            tsigrec.toWire(out, 3, c);
            newheader.incCount(3);
            out.save();
            out.jump(startpos);
            newheader.toWire(out);
            out.restore();
        }
        return true;
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        this.size = out.current();
        return out.toByteArray();
    }

    public byte[] toWire(int maxLength) {
        DNSOutput out = new DNSOutput();
        this.toWire(out, maxLength);
        this.size = out.current();
        return out.toByteArray();
    }

    public void setTSIG(TSIG key, int error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int i) {
        Record[] records;
        if (i > 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Record rec : records = this.getSectionArray(i)) {
            if (i == 0) {
                sb.append(";;\t").append(rec.name);
                sb.append(", type = ").append(Type.string(rec.type));
                sb.append(", class = ").append(DClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode())).append("\n");
        } else {
            sb.append(this.header).append("\n");
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        for (int i = 0; i < 4; ++i) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; ").append(Section.longString(i)).append(":\n");
            } else {
                sb.append(";; ").append(Section.updString(i)).append(":\n");
            }
            sb.append(this.sectionToString(i)).append("\n");
        }
        sb.append(";; Message size: ").append(this.numBytes()).append(" bytes");
        return sb.toString();
    }

    public Object clone() {
        Message m = new Message();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            m.sections[i] = new LinkedList(this.sections[i]);
        }
        m.header = (Header)this.header.clone();
        m.size = this.size;
        return m;
    }
}

