/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.LockInfo;
import io.milton.http.Request;
import io.milton.principal.DiscretePrincipal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class LockInfoSaxHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(LockInfoSaxHandler.class);
    private final LockInfo info = new LockInfo();
    private StringBuilder owner;
    private final Stack<String> elementPath = new Stack();

    public static LockInfo parseLockInfo(Request request) throws IOException, SAXException {
        InputStream in = request.getInputStream();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        LockInfoSaxHandler handler = new LockInfoSaxHandler();
        reader.setContentHandler(handler);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)bout);
            byte[] bytes = bout.toByteArray();
            in = new ByteArrayInputStream(bytes);
            log.debug("LockInfo: " + bout.toString());
        }
        reader.parse(new InputSource(in));
        LockInfo info = handler.getInfo();
        info.depth = LockInfo.LockDepth.INFINITY;
        if (info.lockedByUser == null && request.getAuthorization() != null) {
            if (request.getAuthorization().getUser() != null) {
                info.lockedByUser = request.getAuthorization().getUser();
            } else {
                Object user = request.getAuthorization().getTag();
                if (user instanceof DiscretePrincipal) {
                    DiscretePrincipal dp = (DiscretePrincipal)user;
                    info.lockedByUser = dp.getPrincipalURL();
                }
            }
        }
        if (info.lockedByUser == null) {
            log.warn("resource is being locked with a null user. This won't really be locked at all...");
        }
        return info;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.elementPath.push(localName);
        if (localName.equals("owner")) {
            this.owner = new StringBuilder();
        }
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.owner != null) {
            this.owner.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (localName.equals("owner")) {
            this.getInfo().lockedByUser = this.owner.toString();
        }
        if (this.elementPath.size() > 1) {
            if (((String)this.elementPath.get(1)).equals("lockscope")) {
                this.getInfo().scope = localName.equals("exclusive") ? LockInfo.LockScope.EXCLUSIVE : (localName.equals("shared") ? LockInfo.LockScope.SHARED : LockInfo.LockScope.NONE);
            } else if (((String)this.elementPath.get(1)).equals("locktype")) {
                this.getInfo().type = localName.equals("read") ? LockInfo.LockType.READ : (localName.equals("write") ? LockInfo.LockType.WRITE : LockInfo.LockType.WRITE);
            }
        }
        super.endElement(uri, localName, name);
    }

    public LockInfo getInfo() {
        return this.info;
    }
}

