/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Delete;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(DeleteAnnotationHandler.class);

    public DeleteAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, Delete.class, Request.Method.DELETE);
    }

    void execute(AnnoResource res) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.trace("execute DELETE method");
        Object source = res.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        try {
            Object[] args = this.annoResourceFactory.buildInvokeArgs(res, cm.method, new Object[0]);
            cm.method.invoke(cm.controller, args);
        }
        catch (BadRequestException | ConflictException | NotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

