/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.http.Auth;
import io.milton.http.LockInfo;
import io.milton.http.LockResult;
import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import io.milton.http.Request;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.FsDirectoryResource;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.resource.CollectionResource;
import io.milton.resource.CopyableResource;
import io.milton.resource.DigestResource;
import io.milton.resource.LockableResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.Resource;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FsResource
implements Resource,
MoveableResource,
CopyableResource,
LockableResource,
DigestResource {
    private static final Logger log = LoggerFactory.getLogger(FsResource.class);
    File file;
    final FileSystemResourceFactory factory;
    final String host;
    String ssoPrefix;

    protected abstract void doCopy(File var1) throws NotAuthorizedException;

    public FsResource(String host, FileSystemResourceFactory factory, File file) {
        this.host = host;
        this.file = file;
        this.factory = factory;
    }

    public File getFile() {
        return this.file;
    }

    public String getUniqueId() {
        String s = this.file.lastModified() + "_" + this.file.length() + "_" + this.file.getAbsolutePath();
        return s.hashCode() + "";
    }

    public String getName() {
        return this.file.getName();
    }

    public Object authenticate(String user, String password) {
        return this.factory.getSecurityManager().authenticate(user, password);
    }

    public Object authenticate(DigestResponse digestRequest) {
        return this.factory.getSecurityManager().authenticate(digestRequest);
    }

    public boolean isDigestAllowed() {
        return this.factory.isDigestAllowed();
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = this.factory.getSecurityManager().authorise(request, method, auth, this);
        if (log.isTraceEnabled()) {
            log.trace("authorise: result=" + b);
        }
        return b;
    }

    public String getRealm() {
        String r = this.factory.getRealm(this.host);
        if (r == null) {
            throw new NullPointerException("Got null realm from: " + this.factory.getClass() + " for host=" + this.host);
        }
        return r;
    }

    public Date getModifiedDate() {
        return new Date(this.file.lastModified());
    }

    public Date getCreateDate() {
        return null;
    }

    public int compareTo(Resource o) {
        return this.getName().compareTo(o.getName());
    }

    public void moveTo(CollectionResource newParent, String newName) {
        File dest;
        FsDirectoryResource newFsParent;
        if (newParent instanceof FsDirectoryResource) {
            newFsParent = (FsDirectoryResource)newParent;
            dest = new File(newFsParent.getFile(), newName);
            boolean ok = this.file.renameTo(dest);
            if (!ok) {
                throw new RuntimeException("Failed to move to: " + dest.getAbsolutePath());
            }
        } else {
            throw new RuntimeException("Destination is an unknown type. Must be a FsDirectoryResource, is a: " + newParent.getClass());
        }
        this.file = dest;
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyMoved(this.factory.toResourcePath(newFsParent.getFile()), this.factory.toResourcePath(this.file)));
    }

    public void copyTo(CollectionResource newParent, String newName) throws NotAuthorizedException {
        if (!(newParent instanceof FsDirectoryResource)) {
            throw new RuntimeException("Destination is an unknown type. Must be a FsDirectoryResource, is a: " + newParent.getClass());
        }
        FsDirectoryResource newFsParent = (FsDirectoryResource)newParent;
        File dest = new File(newFsParent.getFile(), newName);
        this.doCopy(dest);
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyCreated(this.factory.toResourcePath(dest)));
    }

    public void delete() {
        boolean ok = this.file.delete();
        if (!ok) {
            throw new RuntimeException("Failed to delete");
        }
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyDeleted(this.factory.toResourcePath(this.file)));
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException {
        LockResult lockResult = this.factory.getLockManager().lock(timeout, lockInfo, (LockableResource)this);
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyLocked(this.factory.toResourcePath(this.file)));
        return lockResult;
    }

    public LockResult refreshLock(String token, LockTimeout timeout) throws NotAuthorizedException {
        LockResult lockResult = this.factory.getLockManager().refresh(token, timeout, (LockableResource)this);
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyLocked(this.factory.toResourcePath(this.file)));
        return lockResult;
    }

    public void unlock(String tokenId) throws NotAuthorizedException {
        this.factory.getLockManager().unlock(tokenId, (LockableResource)this);
        this.factory.getWsManager().ifPresent(wsManager -> wsManager.notifyUnlocked(this.factory.toResourcePath(this.file)));
    }

    public LockToken getCurrentLock() {
        if (this.factory.getLockManager() != null) {
            return this.factory.getLockManager().getCurrentToken((LockableResource)this);
        }
        log.warn("getCurrentLock called, but no lock manager: file: " + this.file.getAbsolutePath());
        return null;
    }
}

