/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.Auth;
import io.milton.http.AuthenticationHandler;
import io.milton.http.Request;
import io.milton.http.SecurityManager;
import io.milton.http.http11.auth.DigestHelper;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.http.http11.auth.ExpiredNonceRemover;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.http11.auth.SimpleMemoryNonceProvider;
import io.milton.resource.Resource;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerDigestAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerDigestAuthenticationHandler.class);
    private final NonceProvider nonceProvider;
    private final SecurityManager securityManager;
    private final DigestHelper digestHelper;

    public SecurityManagerDigestAuthenticationHandler(NonceProvider nonceProvider, SecurityManager securityManager) {
        this.nonceProvider = nonceProvider;
        this.securityManager = securityManager;
        this.digestHelper = new DigestHelper(nonceProvider);
    }

    public SecurityManagerDigestAuthenticationHandler(SecurityManager securityManager) {
        ConcurrentHashMap<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
        int nonceValiditySeconds = 86400;
        ExpiredNonceRemover expiredNonceRemover = new ExpiredNonceRemover(nonces, nonceValiditySeconds);
        this.nonceProvider = new SimpleMemoryNonceProvider(nonceValiditySeconds, expiredNonceRemover, nonces);
        this.securityManager = securityManager;
        this.digestHelper = new DigestHelper(this.nonceProvider);
    }

    @Override
    public boolean credentialsPresent(Request request) {
        return request.getAuthorization() != null;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        if (auth == null) {
            return false;
        }
        return Auth.Scheme.DIGEST.equals((Object)auth.getScheme());
    }

    @Override
    public Object authenticate(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        DigestResponse resp = this.digestHelper.calculateResponse(auth, this.securityManager.getRealm(request.getHostHeader()), request.getMethod());
        if (resp == null) {
            log.debug("requested digest authentication is invalid or incorrectly formatted");
            return null;
        }
        return this.securityManager.authenticate(resp);
    }

    @Override
    public void appendChallenges(Resource resource, Request request, List<String> challenges) {
        String nonceValue = this.nonceProvider.createNonce(request);
        challenges.add(this.digestHelper.getChallenge(nonceValue, request.getAuthorization(), this.securityManager.getRealm(request.getHostHeader())));
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        return true;
    }
}

