/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.ldap.Condition;
import io.milton.ldap.Conditions;
import io.milton.ldap.LdapFilter;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.MultiCondition;
import io.milton.resource.LdapContact;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompoundLdapFilter
implements LdapFilter {
    private final Conditions conditions;
    private final Set<LdapFilter> criteria = new HashSet<LdapFilter>();
    private final int type;

    CompoundLdapFilter(Conditions conditions, int filterType) {
        this.conditions = conditions;
        this.type = filterType;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.type == 161) {
            buffer.append("(|");
        } else if (this.type == 160) {
            buffer.append("(&");
        } else {
            buffer.append("(!");
        }
        for (LdapFilter child : this.criteria) {
            buffer.append(child.toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public void add(LdapFilter filter) {
        this.criteria.add(filter);
    }

    @Override
    public boolean isFullSearch() {
        for (LdapFilter child : this.criteria) {
            if (child.isFullSearch()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Condition getContactSearchFilter() {
        MultiCondition condition = this.type == 161 ? this.conditions.or(new Condition[0]) : this.conditions.and(new Condition[0]);
        for (LdapFilter child : this.criteria) {
            condition.add(child.getContactSearchFilter());
        }
        return condition;
    }

    @Override
    public boolean isMatch(LdapContact person) throws NotAuthorizedException, BadRequestException {
        if (this.type == 161) {
            for (LdapFilter child : this.criteria) {
                if (child.isFullSearch() || !child.isMatch(person)) continue;
                return true;
            }
            return false;
        }
        if (this.type == 160) {
            for (LdapFilter child : this.criteria) {
                if (child.isFullSearch() || child.isMatch(person)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<LdapContact> findInGAL(LdapPrincipal user, Set<String> returningAttributes, int sizeLimit) throws IOException, NotAuthorizedException, BadRequestException {
        List<LdapContact> persons = null;
        for (LdapFilter child : this.criteria) {
            List<LdapContact> childFind;
            int currentSizeLimit = sizeLimit;
            if (persons != null) {
                currentSizeLimit -= persons.size();
            }
            if ((childFind = child.findInGAL(user, returningAttributes, currentSizeLimit)) == null) continue;
            if (persons == null) {
                persons = childFind;
                continue;
            }
            if (this.type == 161) {
                persons.addAll(childFind);
                continue;
            }
            if (this.type != 160) continue;
            for (LdapContact result : childFind) {
                if (!this.isMatch(result)) continue;
                persons.add(result);
            }
        }
        if (persons == null && !this.isFullSearch()) {
            return new ArrayList<LdapContact>();
        }
        return persons;
    }
}

