/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.AbstractRequest;
import io.milton.http.Auth;
import io.milton.http.BeanCookie;
import io.milton.http.Cookie;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.http.Response;
import io.milton.servlet.FileItemWrapper;
import io.milton.servlet.upload.MonitoredDiskFileItemFactory;
import io.milton.servlet.upload.UploadListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(ServletRequest.class);
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private final Request.Method method;
    private final String url;
    private Auth auth;
    private static final Map<Response.ContentType, String> contentTypes = new EnumMap<Response.ContentType, String>(Response.ContentType.class);
    private static final Map<String, Response.ContentType> typeContents = new HashMap<String, Response.ContentType>();
    private static final ThreadLocal<HttpServletRequest> tlRequest;
    private static final ThreadLocal<ServletContext> tlServletContext;

    public static BeanCookie toBeanCookie(javax.servlet.http.Cookie c) {
        BeanCookie bc = new BeanCookie(c.getName());
        bc.setDomain(c.getDomain());
        bc.setExpiry(c.getMaxAge());
        bc.setHttpOnly(true);
        bc.setPath(c.getPath());
        bc.setSecure(c.getSecure());
        bc.setValue(c.getValue());
        bc.setVersion(c.getVersion());
        return bc;
    }

    public static HttpServletRequest getRequest() {
        return tlRequest.get();
    }

    public static ServletContext getTLServletContext() {
        return tlServletContext.get();
    }

    static void clearThreadLocals() {
        tlRequest.remove();
        tlServletContext.remove();
    }

    public ServletRequest(HttpServletRequest r, ServletContext servletContext) {
        this.request = r;
        this.servletContext = servletContext;
        String sMethod = r.getMethod();
        this.method = Request.Method.valueOf((String)sMethod);
        this.url = r.getRequestURL().toString();
        tlRequest.set(r);
        tlServletContext.set(servletContext);
        if (log.isTraceEnabled()) {
            log.trace("Dumping headers ---- " + r.getMethod() + " " + r.getRequestURL() + " -----");
            log.trace("Request class: " + r.getClass());
            log.trace("Response class: " + r.getClass());
            Enumeration names = r.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = r.getHeader(name);
                log.trace("  " + name + "=" + value);
            }
            log.trace("-------------------------------------------");
        }
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public String getFromAddress() {
        return this.request.getRemoteHost();
    }

    @Override
    public String getRequestHeader(Request.Header header) {
        return this.request.getHeader(header.code);
    }

    public Request.Method getMethod() {
        return this.method;
    }

    public String getAbsoluteUrl() {
        return this.url;
    }

    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null) {
            log.trace("getAuthorization: No http credentials in request headers");
            return null;
        }
        if (enc.length() == 0) {
            log.trace("getAuthorization: No http credentials in request headers; authorization header is not-null, but is empty");
            return null;
        }
        this.auth = new Auth(enc);
        if (log.isTraceEnabled()) {
            log.trace("creating new auth object {}", (Object)this.auth.getScheme());
        }
        return this.auth;
    }

    public void setAuthorization(Auth auth) {
        this.auth = auth;
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public void parseRequestParameters(Map<String, String> params, Map<String, io.milton.http.FileItem> files) throws RequestParseException {
        try {
            if (this.isMultiPart()) {
                log.trace("parseRequestParameters: isMultiPart");
                UploadListener listener = new UploadListener();
                MonitoredDiskFileItemFactory factory = new MonitoredDiskFileItemFactory(listener);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(this.request);
                this.parseQueryString(params);
                for (Object o : items) {
                    FileItem item = (FileItem)o;
                    if (item.isFormField()) {
                        params.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    String itemKey = item.getFieldName();
                    if (files.containsKey(itemKey)) {
                        int count = 1;
                        while (files.containsKey(itemKey + count)) {
                            ++count;
                        }
                        itemKey = itemKey + count;
                    }
                    files.put(itemKey, new FileItemWrapper(item));
                }
            } else {
                Enumeration en = this.request.getParameterNames();
                while (en.hasMoreElements()) {
                    String nm = (String)en.nextElement();
                    String[] vals = this.request.getParameterValues(nm);
                    if (vals.length == 1) {
                        params.put(nm, vals[0]);
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String s : vals) {
                        sb.append(s).append(",");
                    }
                    if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    params.put(nm, sb.toString());
                }
            }
        }
        catch (FileUploadException ex) {
            throw new RequestParseException("FileUploadException", (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new RequestParseException(ex.getMessage(), ex);
        }
    }

    private void parseQueryString(Map<String, String> map) {
        String qs = this.request.getQueryString();
        ServletRequest.parseQueryString(map, qs);
    }

    public static void parseQueryString(Map<String, String> map, String qs) {
        String[] nvs;
        if (qs == null) {
            return;
        }
        for (String nv : nvs = qs.split("&")) {
            String[] parts = nv.split("=");
            String key = parts[0];
            String val = null;
            if (parts.length > 1) {
                val = parts[1];
            }
            if (val != null) {
                try {
                    val = URLDecoder.decode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            map.put(key, val);
        }
    }

    protected Response.ContentType getRequestContentType() {
        String s = this.request.getContentType();
        log.trace("request content type - {}", (Object)s);
        if (s == null) {
            return null;
        }
        if (s.contains("multipart/form-data")) {
            return Response.ContentType.MULTIPART;
        }
        return typeContents.get(s);
    }

    protected boolean isMultiPart() {
        Response.ContentType ct = this.getRequestContentType();
        log.trace("content type: {}", (Object)ct);
        return Response.ContentType.MULTIPART.equals((Object)ct);
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration num = this.request.getHeaderNames();
        while (num.hasMoreElements()) {
            String name = (String)num.nextElement();
            String val = this.request.getHeader(name);
            map.put(name, val);
        }
        return map;
    }

    public Cookie getCookie(String name) {
        if (this.request.getCookies() != null) {
            for (javax.servlet.http.Cookie c : this.request.getCookies()) {
                if (!c.getName().equals(name)) continue;
                return ServletRequest.toBeanCookie(c);
            }
        }
        return null;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        if (this.request.getCookies() != null) {
            for (javax.servlet.http.Cookie c : this.request.getCookies()) {
                list.add((Cookie)ServletRequest.toBeanCookie(c));
            }
        }
        return list;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    static {
        contentTypes.put(Response.ContentType.HTTP, "text/html");
        contentTypes.put(Response.ContentType.MULTIPART, "multipart/form-data");
        contentTypes.put(Response.ContentType.XML, "text/xml; charset=UTF-8");
        for (Response.ContentType key : contentTypes.keySet()) {
            typeContents.put(contentTypes.get(key), key);
        }
        tlRequest = new ThreadLocal();
        tlServletContext = new ThreadLocal();
    }
}

