/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.AddressBooks;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBooksAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AddressBooksAnnotationHandler.class);

    public AddressBooksAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, AddressBooks.class, new Request.Method[0]);
    }

    public boolean hasAddressBooks(Object source) {
        for (ControllerMethod cm : this.getMethods(source.getClass())) {
            AddressBooks c = cm.method.getAnnotation(AddressBooks.class);
            if (c == null) continue;
            return true;
        }
        log.warn("No address books found from annotation handler for source: " + source.getClass());
        return false;
    }
}

