/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.MakeCalendar;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeCalendarAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(MakeCalendarAnnotationHandler.class);

    public MakeCalendarAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, MakeCalendar.class, Request.Method.MKCALENDAR);
    }

    public Object execute(AnnoResource res, String newName, Map<QName, String> fieldsToSet) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.trace("execute MKCALENDAR method");
        Object source = res.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            throw new RuntimeException("Method not found: " + this.getClass() + " - " + source.getClass());
        }
        try {
            Object[] args = this.annoResourceFactory.buildInvokeArgs(res, cm.method, newName, fieldsToSet);
            Object o = cm.method.invoke(cm.controller, args);
            if (o == null) {
                throw new RuntimeException("Method returned null object or void: " + cm.controller.getClass() + "::" + cm.method.getName() + " - should return newly created object");
            }
            return o;
        }
        catch (BadRequestException | ConflictException | NotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

