/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.LogUtils;
import io.milton.http.Range;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.ValueAndType;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.resource.CollectionResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropFindHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonPropFindHandler.class);
    private final PropFindPropertyBuilder propertyBuilder;
    private final Helper helper;

    public JsonPropFindHandler(PropFindPropertyBuilder propertyBuilder) {
        this.propertyBuilder = propertyBuilder;
        this.helper = new Helper();
    }

    public void sendContent(PropFindableResource wrappedResource, String encodedUrl, OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
        JSON json;
        log.debug("sendContent: " + encodedUrl);
        JsonConfig cfg = new JsonConfig();
        cfg.setIgnoreTransientFields(true);
        cfg.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        PrintWriter writer = new PrintWriter(out);
        if (this.propertyBuilder == null) {
            if (wrappedResource instanceof CollectionResource) {
                List children = ((CollectionResource)wrappedResource).getChildren();
                json = JSONSerializer.toJSON(this.toSimpleList(children), (JsonConfig)cfg);
            } else {
                json = JSONSerializer.toJSON((Object)this.toSimple((Resource)wrappedResource), (JsonConfig)cfg);
            }
        } else {
            List<PropFindResponse> props;
            String sFields = params.get("fields");
            HashSet<QName> fields = new HashSet<QName>();
            HashMap<QName, String> aliases = new HashMap<QName, String>();
            if (sFields != null && sFields.length() > 0) {
                String[] arr;
                for (String s : arr = sFields.split(",")) {
                    this.parseField(s, fields, aliases);
                }
            }
            String sDepth = params.get("depth");
            int depth = 1;
            if (sDepth != null && sDepth.trim().length() > 0) {
                depth = Integer.parseInt(sDepth);
            }
            String href = encodedUrl.replace("/_DAV/PROPFIND", "");
            PropertiesRequest parseResult = new PropertiesRequest(this.toProperties(fields));
            LogUtils.debug((Logger)log, (Object[])new Object[]{"prop builder: ", this.propertyBuilder.getClass(), "href", href});
            try {
                props = this.propertyBuilder.buildProperties(wrappedResource, depth, parseResult, href);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Requested url is not properly encoded: " + href, ex);
            }
            String where = params.get("where");
            this.filterResults(props, where);
            List<Map<String, Object>> list = this.helper.toMap(props, aliases);
            json = JSONSerializer.toJSON(list, (JsonConfig)cfg);
        }
        json.write((Writer)writer);
        ((Writer)writer).flush();
    }

    private Set<PropertiesRequest.Property> toProperties(Set<QName> set) {
        HashSet<PropertiesRequest.Property> props = new HashSet<PropertiesRequest.Property>();
        for (QName n : set) {
            props.add(new PropertiesRequest.Property(n, null));
        }
        return props;
    }

    void parseField(String field, Set<QName> fields, Map<QName, String> aliases) {
        String alias = null;
        if (field.contains(">")) {
            int pos = field.indexOf(">");
            alias = field.substring(pos + 1);
            field = field.substring(0, pos);
        }
        QName qn = this.parseQName(field);
        fields.add(qn);
        if (alias != null) {
            aliases.put(qn, alias);
        }
    }

    private QName parseQName(String field) {
        if (field.contains(":")) {
            String[] parts = field.split(":");
            String nsUri = parts[0];
            String localName = parts[1];
            return new QName(nsUri, localName);
        }
        return new QName(WebDavProtocol.NS_DAV.getName(), field);
    }

    private List<SimpleResource> toSimpleList(List<? extends Resource> list) {
        ArrayList<SimpleResource> simpleList = new ArrayList<SimpleResource>(list.size());
        for (Resource resource : list) {
            simpleList.add(this.toSimple(resource));
        }
        return simpleList;
    }

    private SimpleResource toSimple(Resource r) {
        return new SimpleResource(r);
    }

    private void filterResults(List<PropFindResponse> results, String where) {
        if (where != null && where.length() > 0) {
            boolean negate = where.startsWith("!");
            if (negate) {
                where = where.substring(1);
            }
            QName qnWhere = this.parseQName(where);
            Iterator<PropFindResponse> it = results.iterator();
            while (it.hasNext()) {
                PropFindResponse result = it.next();
                boolean isTrue = this.eval(qnWhere, result);
                if (isTrue != negate) continue;
                it.remove();
            }
        }
    }

    private boolean eval(QName qnWhere, PropFindResponse result) {
        ValueAndType prop = (ValueAndType)result.getKnownProperties().get(qnWhere);
        if (prop != null) {
            Object val = prop.getValue();
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return false;
        }
        return false;
    }

    static class Helper {
        Helper() {
        }

        private List<Map<String, Object>> toMap(List<PropFindResponse> props, Map<QName, String> aliases) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (PropFindResponse prop : props) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                list.add(map);
                for (Map.Entry p : prop.getKnownProperties().entrySet()) {
                    String name = aliases.get(p.getKey());
                    if (name == null) {
                        name = ((QName)p.getKey()).getLocalPart();
                    }
                    Object val = ((ValueAndType)p.getValue()).getValue();
                    map.put(name, val);
                }
            }
            return list;
        }
    }

    public static class SimpleResource {
        private final Resource r;

        public SimpleResource(Resource r) {
            this.r = r;
        }

        public String getName() {
            return this.r.getName();
        }

        public Date getModifiedDate() {
            return this.r.getModifiedDate();
        }
    }
}

