/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.Filter;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain {
    private static final Logger log = LoggerFactory.getLogger(FilterChain.class);
    final HttpManager httpManager;
    int pos = 0;

    public FilterChain(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    public void process(Request request, Response response) {
        Filter filter = this.httpManager.getFilters().get(this.pos++);
        long tm = System.currentTimeMillis();
        filter.process(this, request, response);
        tm = System.currentTimeMillis() - tm;
        if (tm > 1000L) {
            log.info("Slow request {}ms in filter {} for path={}", new Object[]{tm, filter, request.getAbsolutePath()});
        }
    }

    public HttpManager getHttpManager() {
        return this.httpManager;
    }
}

