/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11;

import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.http11.ContentGenerator;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContentGenerator
implements ContentGenerator {
    private static final Logger log = LoggerFactory.getLogger(SimpleContentGenerator.class);
    private String methodNotAllowed = "<html><body><h1>Method Not Allowed</h1></body></html>";
    private String notFound = "<html><body><h1>${url} Not Found (404)</h1></body></html>";
    private String methodNotImplemented = "<html><body><h1>Method Not Implemented</h1></body></html>";
    private String conflict = "<html><body><h1>Conflict</h1></body></html>";
    private String serverError = "<html><body><h1>Server Error</h1></body></html>";
    private String unauthorised = "<html><body><h1>Not authorised</h1></body></html>";
    private String loginExternal = "<html><body><h1>Not authorised</h1><p>Please login with: ${externalProviders}</p></body></html>";
    private String unknown = "<html><body><h1>Unknown error</h1></body></html>";

    @Override
    public void generate(Resource resource, Request request, Response response, Response.Status status) {
        String finalTemplate = this.applyTemplates(switch (status) {
            case Response.Status.SC_METHOD_NOT_ALLOWED -> this.getMethodNotAllowed();
            case Response.Status.SC_NOT_FOUND -> this.getNotFound();
            case Response.Status.SC_NOT_IMPLEMENTED -> this.getMethodNotImplemented();
            case Response.Status.SC_CONFLICT -> this.getConflict();
            case Response.Status.SC_INTERNAL_SERVER_ERROR -> this.getServerError();
            case Response.Status.SC_UNAUTHORIZED -> this.getUnauthorised();
            default -> this.getUnknown();
        }, request);
        response.setEntity((response1, outputStream) -> {
            outputStream.write(finalTemplate.getBytes("UTF-8"));
            outputStream.flush();
        });
    }

    private String applyTemplates(String template, Request request) {
        template = template.replace("${url}", request.getAbsolutePath());
        return template;
    }

    public String getMethodNotAllowed() {
        return this.methodNotAllowed;
    }

    public void setMethodNotAllowed(String methodNotAllowed) {
        this.methodNotAllowed = methodNotAllowed;
    }

    public String getNotFound() {
        return this.notFound;
    }

    public void setNotFound(String notFound) {
        this.notFound = notFound;
    }

    public String getMethodNotImplemented() {
        return this.methodNotImplemented;
    }

    public void setMethodNotImplemented(String methodNotImplemented) {
        this.methodNotImplemented = methodNotImplemented;
    }

    public String getConflict() {
        return this.conflict;
    }

    public void setConflict(String conflict) {
        this.conflict = conflict;
    }

    public String getServerError() {
        return this.serverError;
    }

    public void setServerError(String serverError) {
        this.serverError = serverError;
    }

    public String getUnauthorised() {
        return this.unauthorised;
    }

    public void setUnauthorised(String unauthorised) {
        this.unauthorised = unauthorised;
    }

    public String getUnknown() {
        return this.unknown;
    }

    public void setUnknown(String unknown) {
        this.unknown = unknown;
    }
}

