/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.FileItem;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PartWrapper
implements FileItem {
    final Part wrapped;
    final String name;
    private Map<String, String> mapOfHeaders;

    public static String fixIEFileName(String s) {
        if (s.contains("\\")) {
            int pos = s.lastIndexOf(92);
            s = s.substring(pos + 1);
        }
        return s;
    }

    public PartWrapper(Part wrapped) {
        this.wrapped = wrapped;
        this.name = PartWrapper.fixIEFileName(wrapped.getName());
    }

    public String getContentType() {
        return this.wrapped.getContentType();
    }

    public String getFieldName() {
        return this.wrapped.getName();
    }

    public InputStream getInputStream() {
        try {
            return this.wrapped.getInputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public Map<String, String> getHeaders() {
        if (this.mapOfHeaders == null) {
            this.mapOfHeaders = new HashMap<String, String>();
            if (this.wrapped.getHeaderNames() != null) {
                Collection headers = this.wrapped.getHeaderNames();
                for (String headerName : headers) {
                    String s = this.wrapped.getHeader(headerName);
                    this.mapOfHeaders.put(headerName, s);
                }
            }
        }
        return this.mapOfHeaders;
    }
}

