/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.webdav;

import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindRequestFieldParser;
import io.milton.http.webdav.PropFindResponse;
import io.milton.http.webdav.PropertiesRequest;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.property.DefaultPropertyAuthoriser;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertyHandler;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFindHandler
implements ExistingEntityHandler,
PropertyHandler {
    private static final Logger log = LoggerFactory.getLogger(PropFindHandler.class);
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final PropFindRequestFieldParser requestFieldParser;
    private final WebDavResponseHandler responseHandler;
    private final PropFindPropertyBuilder propertyBuilder;
    private final PropertyAuthoriser permissionService = new DefaultPropertyAuthoriser();

    public PropFindHandler(ResourceHandlerHelper resourceHandlerHelper, PropFindRequestFieldParser requestFieldParser, WebDavResponseHandler responseHandler, PropFindPropertyBuilder propertyBuilder) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.requestFieldParser = requestFieldParser;
        if (requestFieldParser == null) {
            throw new NullPointerException("Must provide a PropFindRequestFieldParser");
        }
        this.responseHandler = responseHandler;
        this.propertyBuilder = propertyBuilder;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.PROPFIND.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof PropFindableResource;
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        manager.onGet(request, response, r, request.getParams());
        this.resourceHandlerHelper.processResource(manager, request, response, r, this, true, request.getParams(), null);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        PropertiesRequest parseResult;
        log.trace("processExistingResource");
        PropFindableResource pfr = (PropFindableResource)resource;
        int depth = request.getDepthHeader();
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setContentTypeHeader("application/xml; charset=utf-8");
        try {
            parseResult = this.requestFieldParser.getRequestedFields(request.getInputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String url = request.getAbsoluteUrl();
        Set<QName> allFields = this.getAllFields(parseResult, pfr);
        Set<PropertyAuthoriser.CheckResult> errorFields = this.permissionService.checkPermissions(request, request.getMethod(), PropertyAuthoriser.PropertyPermission.READ, allFields, resource);
        if (errorFields != null && errorFields.size() > 0) {
            if (log.isTraceEnabled()) {
                log.trace("permissionService denied access: " + this.permissionService.getClass().getCanonicalName());
            }
            this.responseHandler.respondUnauthorised(resource, response, request);
        } else {
            List<PropFindResponse> propFindResponses;
            if (log.isTraceEnabled()) {
                log.trace("Listing requested propfind properties ---");
                for (PropertiesRequest.Property p : parseResult.getProperties()) {
                    log.trace(p.getName().toString());
                }
                log.trace("---");
            }
            try {
                propFindResponses = this.propertyBuilder.buildProperties(pfr, depth, parseResult, url);
            }
            catch (URISyntaxException ex) {
                log.error("Exception parsing url. request class: " + request.getClass() + ". Please check the client application is usign percentage encoding (see http://en.wikipedia.org/wiki/Percent-encoding)");
                throw new RuntimeException("Exception parsing url, indicating the requested URL is not correctly encoded. Please check the client application. Requested url is: " + url, ex);
            }
            if (log.isTraceEnabled()) {
                log.trace("responses: " + propFindResponses.size());
            }
            this.responseHandler.respondPropFind(propFindResponses, response, request, (Resource)pfr);
        }
    }

    private Set<QName> getAllFields(PropertiesRequest parseResult, PropFindableResource resource) throws NotAuthorizedException, BadRequestException {
        HashSet<QName> set = new HashSet<QName>();
        if (parseResult.isAllProp()) {
            set.addAll(this.propertyBuilder.findAllProps(resource));
        } else {
            set.addAll(parseResult.getNames());
        }
        return set;
    }

    @Override
    public PropertyAuthoriser getPermissionService() {
        return this.permissionService;
    }
}

