/*
 * Decompiled with CFR 0.152.
 */
package io.milton.proxy;

import io.milton.common.Service;
import io.milton.proxy.ProxyConn;
import java.net.ServerSocket;
import java.net.Socket;

public class ProxyServer
implements Runnable,
Service {
    private boolean debug = false;
    private int targetPort;
    private int listenPort;
    private String targetHost;
    protected Thread thread;
    private boolean running;

    public ProxyServer() {
    }

    public ProxyServer(String targetHost, int targetPort, int listenPort) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.listenPort = listenPort;
    }

    public void go() {
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        System.out.println("starting listening on: " + this.listenPort);
        try {
            ServerSocket ss = new ServerSocket(this.listenPort);
            if (this.debug) {
                System.err.println("proxyserver: " + this.listenPort + " listening");
            }
            while (this.running) {
                Socket sconn = ss.accept();
                if (this.debug) {
                    System.err.print(" gotConn: " + this.listenPort + " ");
                }
                this.gotconn(sconn);
            }
        }
        catch (Throwable e) {
            if (this.debug) {
                System.err.println("proxyserver: " + this.listenPort + " " + e.toString());
            }
            e.printStackTrace();
        }
    }

    protected void gotconn(Socket sconn) throws Exception {
        ProxyConn pc = new ProxyConn(sconn, this.targetHost, this.targetPort);
        pc.go();
    }

    public static void main(String[] args) {
        String targetHost = args[0];
        Integer targetPort = new Integer(args[1]);
        Integer listenPort = new Integer(args[2]);
        ProxyServer us = new ProxyServer(targetHost, targetPort, listenPort);
        us.go();
    }

    public void start() {
        this.go();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public void setTargetPort(int targetPort) {
        this.targetPort = targetPort;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public void setTargetHost(String targetHost) {
        this.targetHost = targetHost;
    }
}

