/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.CalendarInvitationsCTag;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarInvitationsCTagAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CalendarInvitationsCTagAnnotationHandler.class);

    public CalendarInvitationsCTagAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, CalendarInvitationsCTag.class, new Request.Method[0]);
    }

    public String getCalendarInvitationsCtag(AnnoPrincipalResource parent) {
        Object source = parent.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        String ctag = null;
        if (cm != null) {
            Object rawId;
            try {
                rawId = cm.method.invoke(cm.controller, source);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            if (rawId != null && (ctag = rawId.toString()).length() == 0) {
                ctag = null;
            }
        }
        return ctag;
    }
}

