/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.Auth;
import io.milton.http.AuthenticationHandler;
import io.milton.http.Request;
import io.milton.resource.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthHandler.class);

    @Override
    public boolean credentialsPresent(Request request) {
        return request.getAuthorization() != null;
    }

    @Override
    public boolean supports(Resource r, Request request) {
        Auth auth = request.getAuthorization();
        if (auth == null) {
            log.trace("supports: no credentials provided");
            return false;
        }
        log.trace("supports: {}", (Object)auth.getScheme());
        boolean b = auth.getScheme().equals((Object)Auth.Scheme.BASIC);
        if (b) {
            log.trace("supports: is BASIC auth scheme, supports = true");
        } else {
            log.trace("supports: is BASIC auth scheme, supports = false");
        }
        return b;
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        log.trace("authenticate");
        Auth auth = request.getAuthorization();
        Object o = resource.authenticate(auth.getUser(), auth.getPassword());
        log.trace("result: {}", o);
        return o;
    }

    @Override
    public void appendChallenges(Resource resource, Request request, List<String> challenges) {
        if (resource == null) {
            throw new RuntimeException("Can't generate challenge because resource is null, so can't get realm");
        }
        challenges.add("Basic realm=\"" + resource.getRealm() + "\"");
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        return true;
    }
}

