/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.FileUtils;
import io.milton.common.Utils;
import io.milton.event.Event;
import io.milton.event.EventManager;
import io.milton.event.PutEvent;
import io.milton.http.FileItem;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonResource;
import io.milton.resource.DeletableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.PutableResource;
import io.milton.resource.ReplaceableResource;
import io.milton.resource.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(PutJsonResource.class);
    public static final String PARAM_AUTONAME = "_autoname";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_OVERWRITE = "overwrite";
    private final EventManager eventManager;
    private final PutableResource wrapped;
    private final String href;
    private List<NewFile> newFiles;
    private String errorMessage;

    public PutJsonResource(PutableResource putableResource, String href, EventManager eventManager) {
        super((Resource)putableResource, Request.Method.PUT.code, null);
        this.eventManager = eventManager;
        this.wrapped = putableResource;
        this.href = href;
    }

    @Override
    public String getContentType(String accepts) {
        return "text/plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws ConflictException, NotAuthorizedException, BadRequestException {
        log.info("processForm: " + this.wrapped.getClass());
        this.newFiles = new ArrayList<NewFile>();
        try {
            if (parameters.containsKey("content")) {
                String name = parameters.get(PARAM_NAME);
                String content = parameters.get("content");
                String contentType = parameters.get("Content-Type");
                byte[] arr = this.toArray(content);
                ByteArrayInputStream in = new ByteArrayInputStream(arr);
                long length = arr.length;
                NewFile nf = new NewFile();
                nf.setOriginalName(name);
                nf.setContentType(contentType);
                nf.setLength(length);
                this.newFiles.add(nf);
                this.processFile(name, in, length, contentType, nf);
            }
            for (FileItem file : files.values()) {
                NewFile nf = new NewFile();
                String ua = HttpManager.request().getUserAgentHeader();
                String f = Utils.truncateFileName((String)ua, (String)file.getName());
                nf.setOriginalName(f);
                nf.setContentType(file.getContentType());
                nf.setLength(file.getSize());
                this.newFiles.add(nf);
                String newName = this.getName(f, parameters);
                log.info("creating resource: " + newName + " size: " + file.getSize());
                InputStream in = null;
                try {
                    in = file.getInputStream();
                    this.processFile(newName, in, file.getSize(), file.getContentType(), nf);
                }
                finally {
                    FileUtils.close((InputStream)in);
                }
            }
            log.trace("completed all POST processing");
        }
        catch (BadRequestException e) {
            log.warn("BadRequestException", (Throwable)e);
            this.errorMessage = "Bad Request: " + e.getReason();
        }
        catch (NotAuthorizedException e) {
            log.warn("NotAuthorizedException", (Throwable)e);
            this.errorMessage = "Not authorised: " + e.getMessage();
        }
        catch (ConflictException e) {
            log.warn("ConflictException", (Throwable)e);
            this.errorMessage = "Conflict: " + e.getMessage();
        }
        return null;
    }

    private byte[] toArray(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(String newName, InputStream in, Long length, String contentType, NewFile nf) throws BadRequestException, NotAuthorizedException, ConflictException {
        try {
            Resource newResource;
            Resource existing = this.wrapped.child(newName);
            if (existing != null) {
                if (existing instanceof ReplaceableResource) {
                    log.trace("existing resource is replaceable, so replace content");
                    ReplaceableResource rr = (ReplaceableResource)existing;
                    rr.replaceContent(in, null);
                    log.trace("completed POST processing for file. Updated: " + existing.getName());
                    this.eventManager.fireEvent((Event)new PutEvent((Resource)rr));
                    newResource = rr;
                } else {
                    log.trace("existing resource is not replaceable, will be deleted");
                    if (!(existing instanceof DeletableResource)) throw new BadRequestException(existing, "existing resource could not be deleted, is not deletable");
                    DeletableResource dr = (DeletableResource)existing;
                    dr.delete();
                    newResource = this.wrapped.createNew(newName, in, length, contentType);
                    log.trace("completed POST processing for file. Deleted, then created: " + newResource.getName());
                    this.eventManager.fireEvent((Event)new PutEvent(newResource));
                }
            } else {
                newResource = this.wrapped.createNew(newName, in, length, contentType);
                if (newResource != null) {
                    log.info("completed POST processing for file. Created: " + newResource.getName());
                } else {
                    log.info("completed POST processing for file. null resource returned");
                }
                this.eventManager.fireEvent((Event)new PutEvent(newResource));
            }
            String newHref = this.buildNewHref(this.href, newResource.getName());
            nf.setHref(newHref);
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception creating resource", ex);
        }
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        JsonConfig cfg = new JsonConfig();
        cfg.setIgnoreTransientFields(true);
        cfg.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        PrintWriter writer = new PrintWriter(out);
        if (this.errorMessage != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", this.errorMessage);
            JSON json = JSONSerializer.toJSON(map, (JsonConfig)cfg);
            json.write((Writer)writer);
        } else {
            NewFile[] arr;
            if (this.newFiles != null) {
                arr = new NewFile[this.newFiles.size()];
                this.newFiles.toArray(arr);
            } else {
                arr = new NewFile[]{};
            }
            JSON json = JSONSerializer.toJSON((Object)arr, (JsonConfig)cfg);
            json.write((Writer)writer);
        }
        ((Writer)writer).flush();
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.PUT;
    }

    private String getName(String filename, Map<String, String> parameters) throws ConflictException, NotAuthorizedException, BadRequestException {
        boolean overwrite;
        String initialName = filename;
        if (parameters.containsKey(PARAM_NAME)) {
            initialName = parameters.get(PARAM_NAME);
        }
        boolean nonBlankName = initialName != null && initialName.trim().length() > 0;
        boolean autoname = parameters.get(PARAM_AUTONAME) != null;
        boolean bl = overwrite = parameters.get(PARAM_OVERWRITE) != null;
        if (nonBlankName) {
            Resource child = this.wrapped.child(initialName);
            if (child == null) {
                log.trace("no existing file with that name");
                return initialName;
            }
            if (overwrite) {
                log.trace("file exists, and overwrite parameters is set, so allow overwrite: " + initialName);
                return initialName;
            }
            if (!autoname) {
                log.warn("Conflict: Can't create resource with name " + initialName + " because it already exists. To rename automatically use request parameter: _autoname, or to overwrite use overwrite");
                throw new ConflictException((Resource)this);
            }
            log.trace("file exists and autoname is set, so will find acceptable name");
        } else {
            initialName = this.getDateAsName("upload");
            log.trace("no name given in request");
        }
        return this.findAcceptableName(initialName);
    }

    private String getDateAsName(String base) {
        Calendar cal = Calendar.getInstance();
        return base + "_" + cal.get(1) + "-" + cal.get(2) + "-" + cal.get(5);
    }

    private String findAcceptableName(String initialName) throws ConflictException, NotAuthorizedException, BadRequestException {
        String baseName = FileUtils.stripExtension((String)initialName);
        String ext = FileUtils.getExtension((String)initialName);
        return this.findAcceptableName(baseName, ext, 1);
    }

    private String findAcceptableName(String baseName, String ext, int i) throws ConflictException, NotAuthorizedException, BadRequestException {
        String candidateName = baseName + "_" + i;
        if (ext != null && ext.length() > 0) {
            candidateName = candidateName + "." + ext;
        }
        if (this.wrapped.child(candidateName) == null) {
            return candidateName;
        }
        if (i < 100) {
            return this.findAcceptableName(baseName, ext, i + 1);
        }
        log.warn("Too many files with similar names: " + candidateName);
        throw new ConflictException((Resource)this);
    }

    private String buildNewHref(String href, String newName) {
        Object s = href;
        int pos = href.lastIndexOf("_DAV");
        if (!((String)(s = ((String)s).substring(0, pos - 1))).endsWith("/")) {
            s = (String)s + "/";
        }
        s = (String)s + newName;
        return s;
    }

    public static class NewFile {
        private String href;
        private String originalName;
        private long length;
        private String contentType;

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

