/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.common.ContentTypeUtils;
import io.milton.http.Auth;
import io.milton.http.Cookie;
import io.milton.http.HttpManager;
import io.milton.http.LockToken;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.resource.GetableResource;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import io.milton.servlet.ServletRequest;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class ServletResource
implements GetableResource {
    private final String localPath;
    private final File file;
    private final String name;
    private final HttpServletRequest req;
    private final HttpServletResponse response;

    public ServletResource(File file, String localPath, HttpServletRequest req, HttpServletResponse response) {
        this.file = file;
        this.name = file.getName();
        this.localPath = localPath;
        this.req = req;
        this.response = response;
    }

    public ServletResource(String localPath, HttpServletRequest req, HttpServletResponse response) {
        this.file = null;
        this.name = localPath.substring(localPath.lastIndexOf("/"));
        this.localPath = localPath;
        this.req = req;
        this.response = response;
    }

    public String getUniqueId() {
        return null;
    }

    public int compareTo(Resource res) {
        return this.getName().compareTo(res.getName());
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        try {
            MyResponse myResponse = new MyResponse(HttpManager.response(), out);
            this.req.getRequestDispatcher(this.localPath).include((jakarta.servlet.ServletRequest)this.req, (ServletResponse)myResponse);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object authenticate(String user, String password) {
        return "ok";
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String getRealm() {
        return "ettrema";
    }

    public Date getModifiedDate() {
        if (this.file != null) {
            return new Date(this.file.lastModified());
        }
        return null;
    }

    public Long getContentLength() {
        return null;
    }

    public String getContentType(String preferredList) {
        if (this.file != null) {
            return ContentTypeUtils.findContentTypes((File)this.file);
        }
        return ContentTypeUtils.findContentTypes((String)this.name);
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return 315360000L;
    }

    public LockToken getLockToken() {
        return null;
    }

    private static class MyResponse
    extends ServletOutputStream
    implements HttpServletResponse {
        private final Response response;
        private final OutputStream out;

        public MyResponse(Response response, OutputStream out) {
            this.response = response;
            this.out = out;
        }

        public void addCookie(jakarta.servlet.http.Cookie cookie) {
            this.response.setCookie((Cookie)ServletRequest.toBeanCookie(cookie));
        }

        public boolean containsHeader(String name) {
            return this.response.getHeaders().containsKey(name);
        }

        public String encodeURL(String url) {
            return MiltonServlet.response().encodeURL(url);
        }

        public String encodeRedirectURL(String url) {
            return MiltonServlet.response().encodeRedirectURL(url);
        }

        public void sendError(int sc, String msg) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sendError(int sc) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sendRedirect(String location) throws IOException {
            MiltonServlet.response().sendRedirect(location);
        }

        public void setDateHeader(String name, long date) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addDateHeader(String name, long date) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setHeader(String name, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addHeader(String name, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setIntHeader(String name, int value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addIntHeader(String name, int value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setStatus(int sc) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStatus() {
            return MiltonServlet.response().getStatus();
        }

        public String getHeader(String s) {
            return MiltonServlet.response().getHeader(s);
        }

        public Collection<String> getHeaders(String s) {
            return MiltonServlet.response().getHeaders(s);
        }

        public Collection<String> getHeaderNames() {
            return MiltonServlet.response().getHeaderNames();
        }

        public String getCharacterEncoding() {
            return MiltonServlet.response().getCharacterEncoding();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this;
        }

        public PrintWriter getWriter() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setContentLength(int len) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setContentLengthLong(long l) {
            MiltonServlet.response().setContentLengthLong(l);
        }

        public void setContentType(String type) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setBufferSize(int size) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getBufferSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void flushBuffer() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void resetBuffer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isCommitted() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void reset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setLocale(Locale loc) {
            MiltonServlet.response().setLocale(loc);
        }

        public Locale getLocale() {
            return MiltonServlet.response().getLocale();
        }

        public void write(int b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public String getContentType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setCharacterEncoding(String charset) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isReady() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

