/*
 * Decompiled with CFR 0.152.
 */
package io.milton.config;

import io.milton.annotations.ResourceController;
import io.milton.cache.CacheManager;
import io.milton.cache.LocalCacheManager;
import io.milton.common.FileUtils;
import io.milton.common.Stoppable;
import io.milton.config.InitListener;
import io.milton.config.ReflectionUtils;
import io.milton.context.RootContext;
import io.milton.event.EventManager;
import io.milton.event.EventManagerImpl;
import io.milton.http.AuthenticationHandler;
import io.milton.http.AuthenticationService;
import io.milton.http.AuthorisationListener;
import io.milton.http.CompressingResponseHandler;
import io.milton.http.Filter;
import io.milton.http.HandlerHelper;
import io.milton.http.HttpExtension;
import io.milton.http.HttpManager;
import io.milton.http.ProtocolHandlers;
import io.milton.http.ResourceFactory;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.SecurityManager;
import io.milton.http.StandardFilter;
import io.milton.http.UrlAdapter;
import io.milton.http.UrlAdapterImpl;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.entity.DefaultEntityTransport;
import io.milton.http.entity.EntityTransport;
import io.milton.http.fck.FckResourceFactory;
import io.milton.http.fs.FileContentService;
import io.milton.http.fs.FileSystemResourceFactory;
import io.milton.http.fs.SimpleFileContentService;
import io.milton.http.fs.SimpleSecurityManager;
import io.milton.http.http11.CacheControlHelper;
import io.milton.http.http11.ContentGenerator;
import io.milton.http.http11.DefaultCacheControlHelper;
import io.milton.http.http11.DefaultETagGenerator;
import io.milton.http.http11.DefaultHttp11ResponseHandler;
import io.milton.http.http11.ETagGenerator;
import io.milton.http.http11.Http11Protocol;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.http.http11.MatchHelper;
import io.milton.http.http11.PartialGetHelper;
import io.milton.http.http11.SimpleContentGenerator;
import io.milton.http.http11.auth.BasicAuthHandler;
import io.milton.http.http11.auth.CookieAuthenticationHandler;
import io.milton.http.http11.auth.DigestAuthenticationHandler;
import io.milton.http.http11.auth.ExpiredNonceRemover;
import io.milton.http.http11.auth.FormAuthenticationHandler;
import io.milton.http.http11.auth.LoginResponseHandler;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.http11.auth.OAuth2AuthenticationHandler;
import io.milton.http.http11.auth.SimpleMemoryNonceProvider;
import io.milton.http.json.JsonPropFindHandler;
import io.milton.http.json.JsonPropPatchHandler;
import io.milton.http.json.JsonResourceFactory;
import io.milton.http.quota.DefaultQuotaDataAccessor;
import io.milton.http.quota.QuotaDataAccessor;
import io.milton.http.values.ValueWriters;
import io.milton.http.webdav.DefaultDisplayNameFormatter;
import io.milton.http.webdav.DefaultPropFindPropertyBuilder;
import io.milton.http.webdav.DefaultPropFindRequestFieldParser;
import io.milton.http.webdav.DefaultUserAgentHelper;
import io.milton.http.webdav.DefaultWebDavResponseHandler;
import io.milton.http.webdav.DisplayNameFormatter;
import io.milton.http.webdav.MsPropFindRequestFieldParser;
import io.milton.http.webdav.PropFindPropertyBuilder;
import io.milton.http.webdav.PropFindRequestFieldParser;
import io.milton.http.webdav.PropFindXmlGenerator;
import io.milton.http.webdav.PropPatchSetter;
import io.milton.http.webdav.PropertySourcePatchSetter;
import io.milton.http.webdav.ResourceTypeHelper;
import io.milton.http.webdav.UserAgentHelper;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.http.webdav.WebDavResourceTypeHelper;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.property.BeanPropertyAuthoriser;
import io.milton.property.BeanPropertySource;
import io.milton.property.DefaultPropertyAuthoriser;
import io.milton.property.MultiNamespaceCustomPropertySource;
import io.milton.property.PropertyAuthoriser;
import io.milton.property.PropertySource;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpManagerBuilder.class);
    protected final boolean enableTextContentProperty = false;
    private final RootContext rootContext = new RootContext();
    protected List<InitListener> listeners;
    protected ResourceFactory mainResourceFactory;
    protected ResourceFactory outerResourceFactory;
    protected FileContentService fileContentService = new SimpleFileContentService();
    protected DefaultHttp11ResponseHandler.BUFFERING buffering;
    protected List<AuthenticationHandler> authenticationHandlers;
    protected List<AuthenticationHandler> extraAuthenticationHandlers;
    protected List<AuthenticationHandler> cookieDelegateHandlers;
    protected DigestAuthenticationHandler digestHandler;
    protected BasicAuthHandler basicHandler;
    protected CookieAuthenticationHandler cookieAuthenticationHandler;
    protected FormAuthenticationHandler formAuthenticationHandler;
    protected Map<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
    protected int nonceValiditySeconds = 86400;
    protected NonceProvider nonceProvider;
    protected AuthenticationService authenticationService;
    protected ExpiredNonceRemover expiredNonceRemover;
    protected List<Stoppable> shutdownHandlers = new CopyOnWriteArrayList<Stoppable>();
    protected ResourceTypeHelper resourceTypeHelper;
    protected WebDavResponseHandler webdavResponseHandler;
    protected WebDavResponseHandler outerWebdavResponseHandler;
    protected ContentGenerator contentGenerator = new SimpleContentGenerator();
    protected CacheControlHelper cacheControlHelper = new DefaultCacheControlHelper();
    protected HandlerHelper handlerHelper;
    protected AuthorisationListener authorisationListener;
    protected ArrayList<HttpExtension> protocols;
    protected ProtocolHandlers protocolHandlers;
    protected EntityTransport entityTransport;
    protected EventManager eventManager = new EventManagerImpl();
    protected PropertyAuthoriser propertyAuthoriser;
    protected List<PropertySource> propertySources;
    protected List<PropertySource> extraPropertySources;
    protected ETagGenerator eTagGenerator = new DefaultETagGenerator();
    protected Http11ResponseHandler http11ResponseHandler;
    protected ValueWriters valueWriters = new ValueWriters();
    protected PropFindXmlGenerator propFindXmlGenerator;
    protected List<Filter> filters;
    protected Filter defaultStandardFilter = new StandardFilter();
    protected UrlAdapter urlAdapter = new UrlAdapterImpl();
    protected QuotaDataAccessor quotaDataAccessor;
    protected PropPatchSetter propPatchSetter;
    protected boolean enableOptionsAuth = false;
    protected ResourceHandlerHelper resourceHandlerHelper;
    protected boolean initDone;
    protected boolean enableCompression = true;
    protected boolean enabledJson = true;
    protected boolean enableBasicAuth = true;
    protected boolean enableDigestAuth = true;
    protected boolean enableFormAuth = true;
    protected boolean enableCookieAuth = true;
    protected boolean enabledCkBrowser = false;
    protected boolean enableEarlyAuth = false;
    protected String loginPage = "/login.html";
    protected List<String> loginPageExcludePaths;
    protected File rootDir = null;
    protected SecurityManager securityManager;
    protected String contextPath;
    protected String fsRealm = "milton";
    protected Map<String, String> mapOfNameAndPasswords;
    protected String defaultUser = "user";
    protected String defaultPassword = "password";
    protected UserAgentHelper userAgentHelper;
    protected MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource;
    protected boolean multiNamespaceCustomPropertySourceEnabled = true;
    protected BeanPropertySource beanPropertySource;
    protected WebDavProtocol webDavProtocol;
    protected DisplayNameFormatter displayNameFormatter = new DefaultDisplayNameFormatter();
    protected boolean webdavEnabled = true;
    protected MatchHelper matchHelper;
    protected PartialGetHelper partialGetHelper;
    protected LoginResponseHandler loginResponseHandler;
    protected LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler = new LoginResponseHandler.ContentTypeLoginPageTypeHandler();
    protected boolean enableExpectContinue = false;
    protected String controllerPackagesToScan;
    protected String controllerClassNames;
    protected List controllers = new ArrayList();
    private Long maxAgeSeconds = 10L;
    private String fsHomeDir = null;
    private PropFindRequestFieldParser propFindRequestFieldParser;
    private PropFindPropertyBuilder propFindPropertyBuilder;
    private CacheManager cacheManager = new LocalCacheManager();
    private List dependencies;
    private List<String> cookieSigningKeys;
    private String cookieSigningKeysFile;
    private boolean useLongLivedCookies = true;
    private boolean enableQuota = false;
    private OAuth2AuthenticationHandler oAuth2Handler;
    private boolean enableOAuth2 = false;

    protected SecurityManager securityManager() {
        if (this.securityManager == null) {
            if (this.mapOfNameAndPasswords == null) {
                this.mapOfNameAndPasswords = new HashMap<String, String>();
                this.mapOfNameAndPasswords.put(this.defaultUser, this.defaultPassword);
                log.info("Configuring default user and password: {}/{} for SimpleSecurityManager", (Object)this.defaultUser, (Object)this.defaultPassword);
            }
            if (this.fsRealm == null) {
                this.fsRealm = "milton";
            }
            this.securityManager = new SimpleSecurityManager(this.fsRealm, this.mapOfNameAndPasswords);
        }
        log.info("Using securityManager: {}", this.securityManager.getClass());
        this.rootContext.put((Object)this.securityManager);
        return this.securityManager;
    }

    public final void init() {
        ResourceFactory resourceFactory;
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.beforeInit(this);
            }
        }
        if (this.dependencies != null) {
            for (InitListener o : this.dependencies) {
                this.rootContext.put((Object)o);
            }
        }
        if (this.mainResourceFactory == null) {
            if (this.fsHomeDir == null) {
                this.fsHomeDir = System.getProperty("user.home");
            }
            this.rootDir = new File(this.fsHomeDir);
            if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
                throw new RuntimeException("Root directory is not valid: " + this.rootDir.getAbsolutePath());
            }
            log.info("Using FileSystemResourceFactory with context path: {}", (Object)this.contextPath);
            FileSystemResourceFactory fsResourceFactory = new FileSystemResourceFactory(this.rootDir, this.securityManager(), this.contextPath);
            fsResourceFactory.setContentService(this.fileContentService);
            this.mainResourceFactory = fsResourceFactory;
            log.info("Using file system with root directory: {}", (Object)this.rootDir.getAbsolutePath());
        }
        if ((resourceFactory = this.mainResourceFactory) instanceof AnnotationResourceFactory) {
            AnnotationResourceFactory arf = (AnnotationResourceFactory)resourceFactory;
            log.info("Set AnnotationResourceFactory context path to: {}", (Object)this.contextPath);
            arf.setContextPath(this.contextPath);
        }
        log.info("Using mainResourceFactory: {}", this.mainResourceFactory.getClass());
        if (this.authenticationService == null) {
            if (this.authenticationHandlers == null) {
                this.authenticationHandlers = new ArrayList<AuthenticationHandler>();
                if (this.basicHandler == null && this.enableBasicAuth) {
                    this.basicHandler = new BasicAuthHandler();
                }
                if (this.basicHandler != null) {
                    this.authenticationHandlers.add(this.basicHandler);
                }
                if (this.nonceProvider == null) {
                    if (this.expiredNonceRemover == null) {
                        this.expiredNonceRemover = new ExpiredNonceRemover(this.nonces, this.nonceValiditySeconds);
                        this.showLog("expiredNonceRemover", this.expiredNonceRemover);
                    }
                    this.nonceProvider = new SimpleMemoryNonceProvider(this.nonceValiditySeconds, this.expiredNonceRemover, this.nonces);
                    this.showLog("nonceProvider", this.nonceProvider);
                }
                if (this.digestHandler == null && this.enableDigestAuth) {
                    this.digestHandler = new DigestAuthenticationHandler(this.nonceProvider);
                }
                if (this.digestHandler != null) {
                    this.authenticationHandlers.add(this.digestHandler);
                }
                if (this.oAuth2Handler == null && this.enableOAuth2) {
                    this.oAuth2Handler = new OAuth2AuthenticationHandler(this.nonceProvider);
                }
                if (this.oAuth2Handler != null) {
                    this.authenticationHandlers.add(this.oAuth2Handler);
                }
                if (this.formAuthenticationHandler == null && this.enableFormAuth) {
                    this.formAuthenticationHandler = new FormAuthenticationHandler();
                }
                if (this.formAuthenticationHandler != null) {
                    this.authenticationHandlers.add(this.formAuthenticationHandler);
                }
                if (this.extraAuthenticationHandlers != null && !this.extraAuthenticationHandlers.isEmpty()) {
                    log.info("Adding extra auth handlers: {}", (Object)this.extraAuthenticationHandlers.size());
                    this.authenticationHandlers.addAll(this.extraAuthenticationHandlers);
                }
                if (this.cookieAuthenticationHandler == null && this.enableCookieAuth) {
                    if (this.cookieDelegateHandlers == null) {
                        this.cookieDelegateHandlers = new ArrayList<AuthenticationHandler>();
                        if (this.basicHandler != null) {
                            this.cookieDelegateHandlers.add(this.basicHandler);
                            this.authenticationHandlers.remove(this.basicHandler);
                        }
                        if (this.digestHandler != null) {
                            this.cookieDelegateHandlers.add(this.digestHandler);
                            this.authenticationHandlers.remove(this.digestHandler);
                        }
                        if (this.formAuthenticationHandler != null) {
                            this.cookieDelegateHandlers.add(this.formAuthenticationHandler);
                            this.authenticationHandlers.remove(this.formAuthenticationHandler);
                        }
                        if (this.oAuth2Handler != null) {
                            this.cookieDelegateHandlers.add(this.oAuth2Handler);
                            this.authenticationHandlers.remove(this.oAuth2Handler);
                        }
                    }
                    this.initCookieSigningKeys();
                    this.cookieAuthenticationHandler = new CookieAuthenticationHandler(this.nonceProvider, this.cookieDelegateHandlers, this.mainResourceFactory, this.cookieSigningKeys);
                    this.cookieAuthenticationHandler.setUseLongLivedCookies(this.useLongLivedCookies);
                    this.authenticationHandlers.add(this.cookieAuthenticationHandler);
                }
            }
            this.authenticationService = new AuthenticationService(this.authenticationHandlers);
            this.rootContext.put((Object)this.authenticationService);
            if (this.cookieAuthenticationHandler != null) {
                this.rootContext.put((Object)this.cookieAuthenticationHandler);
            }
            this.showLog("authenticationService", this.authenticationService);
        }
        this.init(this.authenticationService);
    }

    protected void initCookieSigningKeys() {
        if (this.cookieSigningKeys == null) {
            this.cookieSigningKeys = new ArrayList<String>();
        }
        if (this.cookieSigningKeys.isEmpty()) {
            File fKeys;
            if (this.cookieSigningKeysFile == null) {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                fKeys = new File(tmpDir, "keys.txt");
            } else {
                fKeys = new File(this.cookieSigningKeysFile);
            }
            if (fKeys.exists()) {
                log.info("Reading cookie signing keys from: {}", (Object)fKeys.getAbsolutePath());
                FileUtils.readLines((File)fKeys, this.cookieSigningKeys);
                log.info("Loaded Keys: {}", (Object)this.cookieSigningKeys.size());
                if (this.cookieSigningKeys.isEmpty()) {
                    newKey = UUID.randomUUID();
                    this.cookieSigningKeys.add(newKey.toString());
                    FileUtils.writeLines((File)fKeys, this.cookieSigningKeys);
                }
                this.cookieSigningKeys.removeIf(StringUtils::isBlank);
            } else {
                log.warn("Cookie signing keys file does not exist: {}. Will attempt to create it with a random key", (Object)fKeys.getAbsolutePath());
                log.warn("*** If using a server cluster you MUST ensure a common key file is used ***");
                newKey = UUID.randomUUID();
                this.cookieSigningKeys.add(newKey.toString());
                FileUtils.writeLines((File)fKeys, this.cookieSigningKeys);
            }
        }
    }

    private void init(AuthenticationService authenticationService) {
        if (this.resourceTypeHelper == null) {
            this.buildResourceTypeHelper();
        }
        if (this.propFindXmlGenerator == null) {
            this.propFindXmlGenerator = new PropFindXmlGenerator(this.valueWriters);
            this.showLog("propFindXmlGenerator", this.propFindXmlGenerator);
        }
        if (this.http11ResponseHandler == null) {
            DefaultHttp11ResponseHandler rh = this.createDefaultHttp11ResponseHandler(authenticationService);
            rh.setCacheControlHelper(this.cacheControlHelper);
            rh.setBuffering(this.buffering);
            this.http11ResponseHandler = rh;
            this.showLog("http11ResponseHandler", this.http11ResponseHandler);
        }
        if (this.webdavResponseHandler == null) {
            this.webdavResponseHandler = new DefaultWebDavResponseHandler(this.http11ResponseHandler, this.resourceTypeHelper, this.propFindXmlGenerator);
        }
        this.outerWebdavResponseHandler = this.webdavResponseHandler;
        if (this.enableCompression) {
            CompressingResponseHandler compressingResponseHandler = new CompressingResponseHandler(this.webdavResponseHandler);
            compressingResponseHandler.setBuffering(this.buffering);
            this.outerWebdavResponseHandler = compressingResponseHandler;
            this.showLog("webdavResponseHandler", this.webdavResponseHandler);
        }
        if (this.enableFormAuth) {
            log.info("form authentication is enabled, so wrap response handler with {}", LoginResponseHandler.class);
            if (this.loginResponseHandler == null) {
                this.loginResponseHandler = new LoginResponseHandler(this.outerWebdavResponseHandler, this.mainResourceFactory, this.loginPageTypeHandler);
                this.loginResponseHandler.setExcludePaths(this.loginPageExcludePaths);
                this.loginResponseHandler.setLoginPage(this.loginPage);
                this.outerWebdavResponseHandler = this.loginResponseHandler;
            }
        }
        this.initAnnotatedResourceFactory();
        this.initProtocols();
        this.afterInit();
    }

    private void initProtocols() {
        this.initDone = true;
        if (this.handlerHelper == null) {
            this.handlerHelper = new HandlerHelper(this.authenticationService, this.authorisationListener);
            this.showLog("handlerHelper", this.handlerHelper);
        }
        if (!this.enableExpectContinue) {
            log.info("ExpectContinue support has been disabled");
        } else {
            log.info("ExpectContinue is enabled. This can cause problems on most servlet containers with clients such as CyberDuck");
        }
        this.handlerHelper.setEnableExpectContinue(this.enableExpectContinue);
        if (this.resourceHandlerHelper == null) {
            this.resourceHandlerHelper = new ResourceHandlerHelper(this.handlerHelper, this.urlAdapter, this.webdavResponseHandler, this.authenticationService);
            this.showLog("resourceHandlerHelper", this.resourceHandlerHelper);
        }
        this.buildOuterResourceFactory();
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.beforeProtocolBuild(this);
            }
        }
        this.buildProtocolHandlers(this.webdavResponseHandler, this.resourceTypeHelper);
        this.filters = this.filters != null ? new ArrayList<Filter>(this.filters) : new ArrayList<Filter>();
        this.filters.add(this.defaultStandardFilter);
    }

    public HttpManager buildHttpManager() {
        if (!this.initDone) {
            this.init();
        }
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.afterInit(this);
            }
        }
        if (this.entityTransport == null) {
            this.entityTransport = new DefaultEntityTransport(this.userAgentHelper());
        }
        HttpManager httpManager = new HttpManager(this.outerResourceFactory, this.outerWebdavResponseHandler, this.protocolHandlers, this.entityTransport, this.filters, this.eventManager, this.shutdownHandlers);
        if (this.listeners != null) {
            for (InitListener l : this.listeners) {
                l.afterBuild(this, httpManager);
            }
        }
        if (this.expiredNonceRemover != null) {
            this.shutdownHandlers.add((Stoppable)this.expiredNonceRemover);
            log.info("Starting {} this will remove Digest nonces from memory when they expire", (Object)this.expiredNonceRemover);
            this.expiredNonceRemover.start();
        }
        return httpManager;
    }

    protected void afterInit() {
    }

    protected PropertyAuthoriser initPropertyAuthoriser() {
        if (this.propertyAuthoriser == null) {
            this.propertyAuthoriser = new DefaultPropertyAuthoriser();
            if (this.beanPropertySource != null) {
                this.propertyAuthoriser = new BeanPropertyAuthoriser(this.beanPropertySource, this.propertyAuthoriser);
            }
        }
        return this.propertyAuthoriser;
    }

    protected List<PropertySource> initDefaultPropertySources(ResourceTypeHelper resourceTypeHelper) {
        this.propFindPropertyBuilder();
        if (this.propertySources == null) {
            throw new RuntimeException("I actually expected propertySources to be created by now and set into the PropfindPropertyBuilder ");
        }
        List<PropertySource> list = this.propertySources;
        if (this.multiNamespaceCustomPropertySource == null && this.multiNamespaceCustomPropertySourceEnabled) {
            this.multiNamespaceCustomPropertySource = new MultiNamespaceCustomPropertySource();
        }
        if (this.multiNamespaceCustomPropertySource != null) {
            list.add(this.multiNamespaceCustomPropertySource);
        }
        if (this.initBeanPropertySource() != null) {
            list.add(this.beanPropertySource);
        }
        return list;
    }

    protected BeanPropertySource initBeanPropertySource() {
        if (this.beanPropertySource == null) {
            this.beanPropertySource = new BeanPropertySource();
        }
        return this.beanPropertySource;
    }

    protected DefaultHttp11ResponseHandler createDefaultHttp11ResponseHandler(AuthenticationService authenticationService) {
        return new DefaultHttp11ResponseHandler(authenticationService, this.eTagGenerator, this.contentGenerator);
    }

    protected void buildResourceTypeHelper() {
        this.resourceTypeHelper = new WebDavResourceTypeHelper();
        this.showLog("resourceTypeHelper", this.resourceTypeHelper);
    }

    protected void buildProtocolHandlers(WebDavResponseHandler webdavResponseHandler, ResourceTypeHelper resourceTypeHelper) {
        if (this.protocols == null) {
            this.protocols = new ArrayList();
            if (this.matchHelper == null) {
                this.matchHelper = new MatchHelper(this.eTagGenerator);
            }
            if (this.partialGetHelper == null) {
                this.partialGetHelper = new PartialGetHelper();
            }
            Http11Protocol http11Protocol = new Http11Protocol(webdavResponseHandler, this.handlerHelper, this.resourceHandlerHelper, this.enableOptionsAuth, this.matchHelper, this.partialGetHelper);
            this.protocols.add(http11Protocol);
            this.initDefaultPropertySources(resourceTypeHelper);
            if (this.extraPropertySources != null) {
                for (PropertySource ps : this.extraPropertySources) {
                    log.info("Add extra property source: {}", ps.getClass());
                    this.propertySources.add(ps);
                }
            }
            this.initWebdavProtocol();
            if (this.webDavProtocol != null) {
                this.protocols.add(this.webDavProtocol);
            }
        }
        if (this.protocolHandlers == null) {
            this.protocolHandlers = new ProtocolHandlers(this.protocols);
        }
    }

    protected void initWebdavProtocol() {
        if (this.propPatchSetter == null) {
            this.propPatchSetter = new PropertySourcePatchSetter(this.propertySources);
        }
        if (this.propFindRequestFieldParser == null) {
            DefaultPropFindRequestFieldParser defaultFieldParse = new DefaultPropFindRequestFieldParser();
            this.propFindRequestFieldParser = new MsPropFindRequestFieldParser(defaultFieldParse);
        }
        if (this.quotaDataAccessor == null && this.enableQuota) {
            this.quotaDataAccessor = new DefaultQuotaDataAccessor();
        }
        if (this.webDavProtocol == null && this.webdavEnabled) {
            this.webDavProtocol = new WebDavProtocol(this.handlerHelper, this.resourceTypeHelper, this.webdavResponseHandler, this.propertySources, this.quotaDataAccessor, this.propPatchSetter, this.initPropertyAuthoriser(), this.eTagGenerator, this.urlAdapter, this.resourceHandlerHelper, this.userAgentHelper(), this.propFindRequestFieldParser(), this.propFindPropertyBuilder(), this.displayNameFormatter, false);
        }
    }

    protected PropFindRequestFieldParser propFindRequestFieldParser() {
        if (this.propFindRequestFieldParser == null) {
            DefaultPropFindRequestFieldParser defaultFieldParse = new DefaultPropFindRequestFieldParser();
            this.propFindRequestFieldParser = new MsPropFindRequestFieldParser(defaultFieldParse);
        }
        return this.propFindRequestFieldParser;
    }

    protected void buildOuterResourceFactory() {
        if (this.outerResourceFactory == null) {
            this.outerResourceFactory = this.mainResourceFactory;
            if (this.enabledJson) {
                this.outerResourceFactory = this.buildJsonResourceFactory();
                log.info("Enabled json/ajax gatewayw with: {}", this.outerResourceFactory.getClass());
            }
            if (this.enabledCkBrowser) {
                this.outerResourceFactory = new FckResourceFactory(this.outerResourceFactory);
                log.info("Enabled CK Editor support with: {}", this.outerResourceFactory.getClass());
            }
        }
    }

    protected JsonResourceFactory buildJsonResourceFactory() {
        JsonPropFindHandler jsonPropFindHandler = new JsonPropFindHandler(this.propFindPropertyBuilder());
        JsonPropPatchHandler jsonPropPatchHandler = new JsonPropPatchHandler(this.buildPatchSetter(), this.initPropertyAuthoriser(), this.eventManager);
        return new JsonResourceFactory(this.outerResourceFactory, this.eventManager, jsonPropFindHandler, jsonPropPatchHandler);
    }

    protected PropPatchSetter buildPatchSetter() {
        if (this.propPatchSetter == null) {
            if (this.propertySources == null) {
                throw new RuntimeException("Property sources have not been initialised yet");
            }
            this.propPatchSetter = new PropertySourcePatchSetter(this.propertySources);
        }
        return this.propPatchSetter;
    }

    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        return this.buffering;
    }

    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        this.buffering = buffering;
    }

    public ResourceFactory getResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mainResourceFactory = resourceFactory;
    }

    public List<AuthenticationHandler> getAuthenticationHandlers() {
        return this.authenticationHandlers;
    }

    public void setAuthenticationHandlers(List<AuthenticationHandler> authenticationHandlers) {
        this.authenticationHandlers = authenticationHandlers;
    }

    public List<AuthenticationHandler> getExtraAuthenticationHandlers() {
        return this.extraAuthenticationHandlers;
    }

    public void setExtraAuthenticationHandlers(List<AuthenticationHandler> extraAuthenticationHandlers) {
        this.extraAuthenticationHandlers = extraAuthenticationHandlers;
    }

    public Map<UUID, Nonce> getNonces() {
        return this.nonces;
    }

    public void setNonces(Map<UUID, Nonce> nonces) {
        this.nonces = nonces;
    }

    public ResourceFactory getMainResourceFactory() {
        return this.mainResourceFactory;
    }

    public void setMainResourceFactory(ResourceFactory mainResourceFactory) {
        this.mainResourceFactory = mainResourceFactory;
    }

    public ResourceFactory getOuterResourceFactory() {
        return this.outerResourceFactory;
    }

    public void setOuterResourceFactory(ResourceFactory outerResourceFactory) {
        this.outerResourceFactory = outerResourceFactory;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public void setNonceValiditySeconds(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public NonceProvider getNonceProvider() {
        return this.nonceProvider;
    }

    public void setNonceProvider(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public ExpiredNonceRemover getExpiredNonceRemover() {
        return this.expiredNonceRemover;
    }

    public void setExpiredNonceRemover(ExpiredNonceRemover expiredNonceRemover) {
        this.expiredNonceRemover = expiredNonceRemover;
    }

    public List<Stoppable> getShutdownHandlers() {
        return this.shutdownHandlers;
    }

    public void setShutdownHandlers(List<Stoppable> shutdownHandlers) {
        this.shutdownHandlers = shutdownHandlers;
    }

    public ResourceTypeHelper getResourceTypeHelper() {
        return this.resourceTypeHelper;
    }

    public void setResourceTypeHelper(ResourceTypeHelper resourceTypeHelper) {
        this.resourceTypeHelper = resourceTypeHelper;
    }

    public WebDavResponseHandler getWebdavResponseHandler() {
        return this.webdavResponseHandler;
    }

    public void setWebdavResponseHandler(WebDavResponseHandler webdavResponseHandler) {
        this.webdavResponseHandler = webdavResponseHandler;
    }

    public HandlerHelper getHandlerHelper() {
        return this.handlerHelper;
    }

    public void setHandlerHelper(HandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    public ArrayList<HttpExtension> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(ArrayList<HttpExtension> protocols) {
        this.protocols = protocols;
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public void setProtocolHandlers(ProtocolHandlers protocolHandlers) {
        this.protocolHandlers = protocolHandlers;
    }

    public EntityTransport getEntityTransport() {
        return this.entityTransport;
    }

    public void setEntityTransport(EntityTransport entityTransport) {
        this.entityTransport = entityTransport;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public PropertyAuthoriser getPropertyAuthoriser() {
        return this.propertyAuthoriser;
    }

    public void setPropertyAuthoriser(PropertyAuthoriser propertyAuthoriser) {
        this.propertyAuthoriser = propertyAuthoriser;
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
    }

    public ETagGenerator geteTagGenerator() {
        return this.eTagGenerator;
    }

    public void seteTagGenerator(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    public Http11ResponseHandler getHttp11ResponseHandler() {
        return this.http11ResponseHandler;
    }

    public void setHttp11ResponseHandler(Http11ResponseHandler http11ResponseHandler) {
        this.http11ResponseHandler = http11ResponseHandler;
    }

    public ValueWriters getValueWriters() {
        return this.valueWriters;
    }

    public void setValueWriters(ValueWriters valueWriters) {
        this.valueWriters = valueWriters;
    }

    public PropFindXmlGenerator getPropFindXmlGenerator() {
        return this.propFindXmlGenerator;
    }

    public void setPropFindXmlGenerator(PropFindXmlGenerator propFindXmlGenerator) {
        this.propFindXmlGenerator = propFindXmlGenerator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public Filter getDefaultStandardFilter() {
        return this.defaultStandardFilter;
    }

    public void setDefaultStandardFilter(Filter defaultStandardFilter) {
        this.defaultStandardFilter = defaultStandardFilter;
    }

    public UrlAdapter getUrlAdapter() {
        return this.urlAdapter;
    }

    public void setUrlAdapter(UrlAdapter urlAdapter) {
        this.urlAdapter = urlAdapter;
    }

    public QuotaDataAccessor getQuotaDataAccessor() {
        return this.quotaDataAccessor;
    }

    public void setQuotaDataAccessor(QuotaDataAccessor quotaDataAccessor) {
        this.quotaDataAccessor = quotaDataAccessor;
    }

    public PropPatchSetter getPropPatchSetter() {
        return this.propPatchSetter;
    }

    public void setPropPatchSetter(PropPatchSetter propPatchSetter) {
        this.propPatchSetter = propPatchSetter;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public void setInitDone(boolean initDone) {
        this.initDone = initDone;
    }

    public boolean isEnableOptionsAuth() {
        return this.enableOptionsAuth;
    }

    public void setEnableOptionsAuth(boolean enableOptionsAuth) {
        this.enableOptionsAuth = enableOptionsAuth;
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }

    public boolean isEnabledJson() {
        return this.enabledJson;
    }

    public void setEnabledJson(boolean enabledJson) {
        this.enabledJson = enabledJson;
    }

    public List<PropertySource> getExtraPropertySources() {
        return this.extraPropertySources;
    }

    public void setExtraPropertySources(List<PropertySource> extraPropertySources) {
        this.extraPropertySources = extraPropertySources;
    }

    protected void showLog(String propertyName, Object defaultedTo) {
        log.info("set property: {} to: {}", (Object)propertyName, defaultedTo);
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public boolean isEnableCookieAuth() {
        return this.enableCookieAuth;
    }

    public void setEnableCookieAuth(boolean enableCookieAuth) {
        this.enableCookieAuth = enableCookieAuth;
    }

    public boolean isEnableDigestAuth() {
        return this.enableDigestAuth;
    }

    public void setEnableDigestAuth(boolean enableDigestAuth) {
        this.enableDigestAuth = enableDigestAuth;
    }

    public boolean isEnableFormAuth() {
        return this.enableFormAuth;
    }

    public void setEnableFormAuth(boolean enableFormAuth) {
        this.enableFormAuth = enableFormAuth;
    }

    public BasicAuthHandler getBasicHandler() {
        return this.basicHandler;
    }

    public void setBasicHandler(BasicAuthHandler basicHandler) {
        this.basicHandler = basicHandler;
    }

    public OAuth2AuthenticationHandler getoAuth2Handler() {
        return this.oAuth2Handler;
    }

    public void setoAuth2Handler(OAuth2AuthenticationHandler oAuth2Handler) {
        this.oAuth2Handler = oAuth2Handler;
    }

    public CookieAuthenticationHandler getCookieAuthenticationHandler() {
        return this.cookieAuthenticationHandler;
    }

    public void setCookieAuthenticationHandler(CookieAuthenticationHandler cookieAuthenticationHandler) {
        this.cookieAuthenticationHandler = cookieAuthenticationHandler;
    }

    public List<AuthenticationHandler> getCookieDelegateHandlers() {
        return this.cookieDelegateHandlers;
    }

    public void setCookieDelegateHandlers(List<AuthenticationHandler> cookieDelegateHandlers) {
        this.cookieDelegateHandlers = cookieDelegateHandlers;
    }

    public DigestAuthenticationHandler getDigestHandler() {
        return this.digestHandler;
    }

    public void setDigestHandler(DigestAuthenticationHandler digestHandler) {
        this.digestHandler = digestHandler;
    }

    public OAuth2AuthenticationHandler getOAuth2Handler() {
        return this.oAuth2Handler;
    }

    public void setOAuth2Handler(OAuth2AuthenticationHandler oAuth2Handler) {
        this.oAuth2Handler = oAuth2Handler;
    }

    public boolean isEnableOAuth2() {
        return this.enableOAuth2;
    }

    public void setEnableOAuth2(boolean enableOAuth2) {
        this.enableOAuth2 = enableOAuth2;
    }

    public FormAuthenticationHandler getFormAuthenticationHandler() {
        return this.formAuthenticationHandler;
    }

    public void setFormAuthenticationHandler(FormAuthenticationHandler formAuthenticationHandler) {
        this.formAuthenticationHandler = formAuthenticationHandler;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public List<String> getLoginPageExcludePaths() {
        return this.loginPageExcludePaths;
    }

    public void setLoginPageExcludePaths(List<String> loginPageExcludePaths) {
        this.loginPageExcludePaths = loginPageExcludePaths;
    }

    public ResourceHandlerHelper getResourceHandlerHelper() {
        return this.resourceHandlerHelper;
    }

    public void setResourceHandlerHelper(ResourceHandlerHelper resourceHandlerHelper) {
        this.resourceHandlerHelper = resourceHandlerHelper;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public String getFsContextPath() {
        return this.contextPath;
    }

    public void setFsContextPath(String fsContextPath) {
        this.contextPath = fsContextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public UserAgentHelper getUserAgentHelper() {
        return this.userAgentHelper;
    }

    public void setUserAgentHelper(UserAgentHelper userAgentHelper) {
        this.userAgentHelper = userAgentHelper;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getFsRealm() {
        return this.fsRealm;
    }

    public void setFsRealm(String fsRealm) {
        this.fsRealm = fsRealm;
    }

    public Map<String, String> getMapOfNameAndPasswords() {
        return this.mapOfNameAndPasswords;
    }

    public void setMapOfNameAndPasswords(Map<String, String> mapOfNameAndPasswords) {
        this.mapOfNameAndPasswords = mapOfNameAndPasswords;
    }

    public MultiNamespaceCustomPropertySource getMultiNamespaceCustomPropertySource() {
        return this.multiNamespaceCustomPropertySource;
    }

    public void setMultiNamespaceCustomPropertySource(MultiNamespaceCustomPropertySource multiNamespaceCustomPropertySource) {
        this.multiNamespaceCustomPropertySource = multiNamespaceCustomPropertySource;
    }

    public BeanPropertySource getBeanPropertySource() {
        return this.beanPropertySource;
    }

    public void setBeanPropertySource(BeanPropertySource beanPropertySource) {
        this.beanPropertySource = beanPropertySource;
    }

    public boolean isEnabledCkBrowser() {
        return this.enabledCkBrowser;
    }

    public void setEnabledCkBrowser(boolean enabledCkBrowser) {
        this.enabledCkBrowser = enabledCkBrowser;
    }

    public WebDavProtocol getWebDavProtocol() {
        return this.webDavProtocol;
    }

    public void setWebDavProtocol(WebDavProtocol webDavProtocol) {
        this.webDavProtocol = webDavProtocol;
    }

    public boolean isWebdavEnabled() {
        return this.webdavEnabled;
    }

    public void setWebdavEnabled(boolean webdavEnabled) {
        this.webdavEnabled = webdavEnabled;
    }

    public MatchHelper getMatchHelper() {
        return this.matchHelper;
    }

    public void setMatchHelper(MatchHelper matchHelper) {
        this.matchHelper = matchHelper;
    }

    public PartialGetHelper getPartialGetHelper() {
        return this.partialGetHelper;
    }

    public void setPartialGetHelper(PartialGetHelper partialGetHelper) {
        this.partialGetHelper = partialGetHelper;
    }

    public boolean isMultiNamespaceCustomPropertySourceEnabled() {
        return this.multiNamespaceCustomPropertySourceEnabled;
    }

    public void setMultiNamespaceCustomPropertySourceEnabled(boolean multiNamespaceCustomPropertySourceEnabled) {
        this.multiNamespaceCustomPropertySourceEnabled = multiNamespaceCustomPropertySourceEnabled;
    }

    public LoginResponseHandler.LoginPageTypeHandler getLoginPageTypeHandler() {
        return this.loginPageTypeHandler;
    }

    public void setLoginPageTypeHandler(LoginResponseHandler.LoginPageTypeHandler loginPageTypeHandler) {
        this.loginPageTypeHandler = loginPageTypeHandler;
    }

    public LoginResponseHandler getLoginResponseHandler() {
        return this.loginResponseHandler;
    }

    public void setLoginResponseHandler(LoginResponseHandler loginResponseHandler) {
        this.loginResponseHandler = loginResponseHandler;
    }

    public List<InitListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<InitListener> listeners) {
        this.listeners = listeners;
    }

    public FileContentService getFileContentService() {
        return this.fileContentService;
    }

    public void setFileContentService(FileContentService fileContentService) {
        this.fileContentService = fileContentService;
    }

    public CacheControlHelper getCacheControlHelper() {
        return this.cacheControlHelper;
    }

    public void setCacheControlHelper(CacheControlHelper cacheControlHelper) {
        this.cacheControlHelper = cacheControlHelper;
    }

    public ContentGenerator getContentGenerator() {
        return this.contentGenerator;
    }

    public void setContentGenerator(ContentGenerator contentGenerator) {
        this.contentGenerator = contentGenerator;
    }

    public boolean isEnableExpectContinue() {
        return this.enableExpectContinue;
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.enableExpectContinue = enableExpectContinue;
    }

    public WebDavResponseHandler getOuterWebdavResponseHandler() {
        return this.outerWebdavResponseHandler;
    }

    public void setOuterWebdavResponseHandler(WebDavResponseHandler outerWebdavResponseHandler) {
        this.outerWebdavResponseHandler = outerWebdavResponseHandler;
    }

    public String getControllerPackagesToScan() {
        return this.controllerPackagesToScan;
    }

    public void setControllerPackagesToScan(String controllerPackagesToScan) {
        if (this.mainResourceFactory == null && controllerPackagesToScan != null) {
            this.mainResourceFactory = new AnnotationResourceFactory();
        }
        this.controllerPackagesToScan = controllerPackagesToScan;
    }

    public String getControllerClassNames() {
        return this.controllerClassNames;
    }

    public void setControllerClassNames(String controlleClassNames) {
        if (this.mainResourceFactory == null && controlleClassNames != null) {
            this.mainResourceFactory = new AnnotationResourceFactory();
        }
        this.controllerClassNames = controlleClassNames;
    }

    public List getControllers() {
        return this.controllers;
    }

    public void setControllers(List controllers) {
        if (this.mainResourceFactory == null && controllers != null) {
            this.mainResourceFactory = new AnnotationResourceFactory();
        }
        this.controllers = controllers;
    }

    public boolean isEnableQuota() {
        return this.enableQuota;
    }

    public void setEnableQuota(boolean enableQuota) {
        this.enableQuota = enableQuota;
    }

    public Long getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Long maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public DisplayNameFormatter getDisplayNameFormatter() {
        return this.displayNameFormatter;
    }

    public void setDisplayNameFormatter(DisplayNameFormatter displayNameFormatter) {
        this.displayNameFormatter = displayNameFormatter;
    }

    public String getFsHomeDir() {
        return this.fsHomeDir;
    }

    public void setFsHomeDir(String fsHomeDir) {
        this.fsHomeDir = fsHomeDir;
    }

    public List<String> getCookieSigningKeys() {
        return this.cookieSigningKeys;
    }

    public void setCookieSigningKeys(List<String> cookieSigningKeys) {
        this.cookieSigningKeys = cookieSigningKeys;
    }

    public boolean isUseLongLivedCookies() {
        return this.useLongLivedCookies;
    }

    public void setUseLongLivedCookies(boolean useLongLivedCookies) {
        this.useLongLivedCookies = useLongLivedCookies;
    }

    public String getCookieSigningKeysFile() {
        return this.cookieSigningKeysFile;
    }

    public void setCookieSigningKeysFile(String cookieSigningKeysFile) {
        this.cookieSigningKeysFile = cookieSigningKeysFile;
    }

    public PropFindPropertyBuilder getPropFindPropertyBuilder() {
        return this.propFindPropertyBuilder;
    }

    public void setPropFindPropertyBuilder(PropFindPropertyBuilder propFindPropertyBuilder) {
        this.propFindPropertyBuilder = propFindPropertyBuilder;
    }

    public PropFindRequestFieldParser getPropFindRequestFieldParser() {
        return this.propFindRequestFieldParser;
    }

    public void setPropFindRequestFieldParser(PropFindRequestFieldParser propFindRequestFieldParser) {
        this.propFindRequestFieldParser = propFindRequestFieldParser;
    }

    private void initAnnotatedResourceFactory() {
        log.info("initAnnotatedResourceFactory");
        try {
            String[] stringArray = this.getMainResourceFactory();
            if (stringArray instanceof AnnotationResourceFactory) {
                AnnotationResourceFactory arf = (AnnotationResourceFactory)stringArray;
                arf.setDoEarlyAuth(this.enableEarlyAuth);
                log.info("enableEarlyAuth={}", (Object)this.enableEarlyAuth);
                if (this.enableEarlyAuth && arf.getAuthenticationService() == null) {
                    if (this.authenticationService == null) {
                        throw new RuntimeException("enableEarlyAuth is true, but not authenticationService is available");
                    }
                    log.info("Enabled early authentication for annotations resources");
                    arf.setAuthenticationService(this.authenticationService);
                }
                if (arf.getControllers() == null) {
                    if (this.controllers == null) {
                        this.controllers = new ArrayList();
                    }
                    if (this.controllerPackagesToScan != null) {
                        log.info("Scan for controller classes: {}", (Object)this.controllerPackagesToScan);
                        if (log.isTraceEnabled()) {
                            log.trace("Searching for classes with annotation: " + ResourceController.class + "(annotation class loader: " + ResourceController.class.getClassLoader() + ")");
                        }
                        HashSet<ClassLoader> classesClassloaders = new HashSet<ClassLoader>();
                        classesClassloaders.add(ResourceController.class.getClassLoader());
                        Object object = this.controllerPackagesToScan.split(",");
                        int n = ((String[])object).length;
                        for (int i = 0; i < n; ++i) {
                            String packageName = object[i];
                            packageName = packageName.trim();
                            log.info("init annotations controllers from package: {}", (Object)packageName);
                            List<Class> classes = ReflectionUtils.getClassNamesFromPackage(packageName);
                            for (Class c : classes) {
                                ResourceController a;
                                if (log.isTraceEnabled()) {
                                    log.trace("Class: " + c + " with annotations: " + Arrays.asList(c.getAnnotations()) + ", classloader: " + c.getClassLoader());
                                    classesClassloaders.add(c.getClassLoader());
                                }
                                if ((a = c.getAnnotation(ResourceController.class)) != null) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("Adding controller with class " + c);
                                    }
                                    Object controller = this.createObject(c);
                                    this.controllers.add(controller);
                                    continue;
                                }
                                if (!log.isTraceEnabled()) continue;
                                log.trace("No " + ResourceController.class + " in " + c + ", skipping");
                            }
                        }
                        if (log.isTraceEnabled()) {
                            object = classesClassloaders.iterator();
                            while (object.hasNext()) {
                                ClassLoader cl;
                                StringBuilder toOut = new StringBuilder("Classloader hierarchy:");
                                for (ClassLoader cur = cl = (ClassLoader)object.next(); cur != null; cur = cur.getParent()) {
                                    toOut.append("\n   id:").append(System.identityHashCode(cur)).append(", class:").append(cur.getClass()).append(": ").append(cur);
                                }
                                log.trace(toOut.toString());
                            }
                        }
                    }
                    if (this.controllerClassNames != null) {
                        log.info("Initialise controller classes: {}", (Object)this.controllerClassNames);
                        for (String className : this.controllerClassNames.split(",")) {
                            className = className.trim();
                            log.info("init annotation controller: {}", (Object)className);
                            Class c = ReflectionUtils.loadClass(className);
                            ResourceController a = c.getAnnotation(ResourceController.class);
                            if (a != null) {
                                Object controller = this.createObject(c);
                                this.controllers.add(controller);
                                continue;
                            }
                            log.warn("No {} annotation on class: {} provided in controlleClassNames", ResourceController.class, (Object)c.getCanonicalName());
                        }
                    }
                    if (this.controllers.isEmpty()) {
                        log.warn("No controllers found in controllerClassNames={} or controllerPackagesToScan={}", (Object)this.controllerClassNames, (Object)this.controllerPackagesToScan);
                    }
                    arf.setControllers(this.controllers);
                }
                if (arf.getMaxAgeSeconds() == null) {
                    arf.setMaxAgeSeconds(this.maxAgeSeconds);
                }
                if (arf.getSecurityManager() == null) {
                    arf.setSecurityManager(this.securityManager());
                }
                this.setDisplayNameFormatter(new AnnotationResourceFactory.AnnotationsDisplayNameFormatter(this.getDisplayNameFormatter()));
            }
        }
        catch (CreationException | IOException | ClassNotFoundException e) {
            throw new RuntimeException("Exception initialising AnnotationResourceFactory", e);
        }
    }

    protected UserAgentHelper userAgentHelper() {
        if (this.userAgentHelper == null) {
            this.userAgentHelper = new DefaultUserAgentHelper();
        }
        return this.userAgentHelper;
    }

    protected PropFindPropertyBuilder propFindPropertyBuilder() {
        if (this.propFindPropertyBuilder == null) {
            if (this.propertySources == null) {
                this.propertySources = new ArrayList<PropertySource>();
            }
            this.propFindPropertyBuilder = new DefaultPropFindPropertyBuilder(this.propertySources);
        }
        return this.propFindPropertyBuilder;
    }

    public RootContext getRootContext() {
        return this.rootContext;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List dependencies) {
        this.dependencies = dependencies;
    }

    public boolean isEnableEarlyAuth() {
        return this.enableEarlyAuth;
    }

    public void setEnableEarlyAuth(boolean enableEarlyAuth) {
        this.enableEarlyAuth = enableEarlyAuth;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private Object createObject(Class c) throws CreationException {
        Inject anno;
        Object created;
        log.info("createObject: {}", (Object)c.getCanonicalName());
        Constructor<?> found = null;
        for (Constructor<?> con : c.getConstructors()) {
            Annotation[][] paramTypes = con.getParameterAnnotations();
            if (paramTypes != null && paramTypes.length > 0) {
                Inject inject = con.getAnnotation(Inject.class);
                if (inject == null) continue;
                found = con;
                continue;
            }
            found = con;
        }
        if (found == null) {
            throw new RuntimeException("Could not find a default or @Inject constructor for class: " + c.getCanonicalName());
        }
        Object[] args = new Object[found.getParameterTypes().length];
        int i = 0;
        for (Class<?> paramType : found.getParameterTypes()) {
            try {
                args[i++] = this.findOrCreateObject(paramType);
            }
            catch (CreationException creationException) {
                throw new CreationException(c, (Throwable)creationException);
            }
        }
        try {
            log.info("Creating: {}", (Object)c.getCanonicalName());
            created = found.newInstance(args);
            this.rootContext.put(created);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new CreationException(c, (Throwable)ex);
        }
        for (Field field : c.getDeclaredFields()) {
            anno = field.getAnnotation(Inject.class);
            if (anno == null) continue;
            boolean acc = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(created, this.findOrCreateObject(field.getType()));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new CreationException(field, c, (Throwable)ex);
            }
            finally {
                field.setAccessible(acc);
            }
        }
        for (AccessibleObject accessibleObject : c.getMethods()) {
            anno = ((Method)accessibleObject).getAnnotation(Inject.class);
            if (anno == null) continue;
            Object[] methodArgs = new Object[((Method)accessibleObject).getParameterTypes().length];
            int ii = 0;
            try {
                for (Class<?> paramType : ((Method)accessibleObject).getParameterTypes()) {
                    methodArgs[ii++] = this.findOrCreateObject(paramType);
                }
                ((Method)accessibleObject).invoke(created, methodArgs);
            }
            catch (CreationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException creationException) {
                throw new CreationException((Method)accessibleObject, c, (Throwable)creationException);
            }
        }
        if (created instanceof InitListener) {
            InitListener l = (InitListener)created;
            if (this.listeners == null) {
                this.listeners = new ArrayList<InitListener>();
            }
            l.beforeInit(this);
            this.listeners.add(l);
        }
        return created;
    }

    private Object findOrCreateObject(Class c) throws CreationException {
        Object o = this.rootContext.get(c);
        if (o == null) {
            o = this.createObject(c);
        }
        return o;
    }

    public AuthorisationListener getAuthorisationListener() {
        return this.authorisationListener;
    }

    public void setAuthorisationListener(AuthorisationListener authorisationListener) {
        this.authorisationListener = authorisationListener;
    }

    public static class CreationException
    extends Exception {
        private final Class attemptedToCreate;

        public CreationException(Class attemptedToCreate, Throwable cause) {
            super("Exception creating: " + attemptedToCreate.getCanonicalName(), cause);
            this.attemptedToCreate = attemptedToCreate;
        }

        public CreationException(Field field, Class attemptedToCreate, Throwable cause) {
            super("Exception setting field: " + field.getName() + " on " + attemptedToCreate.getCanonicalName(), cause);
            this.attemptedToCreate = attemptedToCreate;
        }

        public CreationException(Method m, Class attemptedToCreate, Throwable cause) {
            super("Exception invoking inject method: " + m.getName() + " on " + attemptedToCreate.getCanonicalName(), cause);
            this.attemptedToCreate = attemptedToCreate;
        }

        public Class getAttemptedToCreate() {
            return this.attemptedToCreate;
        }
    }
}

