/*
 * Decompiled with CFR 0.152.
 */
package io.milton.gae;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.milton.http.Request;
import io.milton.http.http11.auth.Nonce;
import io.milton.http.http11.auth.NonceProvider;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class AppEngineMemcacheNonceProvider
implements NonceProvider {
    private static final Logger log = Logger.getLogger(AppEngineMemcacheNonceProvider.class.getName());
    protected final int nonceValiditySeconds;
    protected boolean enableNonceCountChecking;
    final Cache<UUID, Nonce> memcache;

    public AppEngineMemcacheNonceProvider(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
        this.memcache = Caffeine.newBuilder().expireAfterWrite((long)nonceValiditySeconds, TimeUnit.SECONDS).maximumSize(10000L).build();
        log.info("created");
    }

    @Override
    public String createNonce(Request request) {
        UUID id = UUID.randomUUID();
        Date now = new Date();
        Nonce n = new Nonce(id, now);
        this.memcache.put((Object)n.getValue(), (Object)n);
        log.info(String.format("created nonce: %s", n.getValue()));
        return n.getValue().toString();
    }

    @Override
    public NonceProvider.NonceValidity getNonceValidity(String nonce, Long nc) {
        log.info(String.format("getNonceValidity: %s", nonce));
        UUID value = null;
        try {
            value = UUID.fromString(nonce);
        }
        catch (Exception e) {
            log.info("couldnt parse nonce");
            return NonceProvider.NonceValidity.INVALID;
        }
        Nonce n = (Nonce)this.memcache.get((Object)value, null);
        if (n == null) {
            log.info("not found in cache");
            return NonceProvider.NonceValidity.INVALID;
        }
        if (this.isExpired(n.getIssued())) {
            log.info("nonce has expired; that is unusual as it should have been evicted from the cache already.");
            return NonceProvider.NonceValidity.EXPIRED;
        }
        if (nc == null) {
            log.info("nonce ok");
            return NonceProvider.NonceValidity.OK;
        }
        if (this.enableNonceCountChecking && nc <= n.getNonceCount()) {
            log.warning(String.format("nonce-count was not greater then previous, possible replay attack. new: %s old:%s", nc, n.getNonceCount()));
            return NonceProvider.NonceValidity.INVALID;
        }
        log.info("nonce and nonce-count ok");
        Nonce newNonce = n.increaseNonceCount(nc);
        this.memcache.put((Object)newNonce.getValue(), (Object)newNonce);
        return NonceProvider.NonceValidity.OK;
    }

    private boolean isExpired(Date issued) {
        long dif = (System.currentTimeMillis() - issued.getTime()) / 1000L;
        return dif > (long)this.nonceValiditySeconds;
    }

    public boolean isEnableNonceCountChecking() {
        return this.enableNonceCountChecking;
    }

    public void setEnableNonceCountChecking(boolean enableNonceCountChecking) {
        this.enableNonceCountChecking = enableNonceCountChecking;
    }
}

