/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.Calendars;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.annotated.ResourceList;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.HrefList;
import io.milton.http.values.SupportedCalendarComponentListsSet;
import io.milton.principal.CalDavPrincipal;
import io.milton.principal.DirectoryGatewayCardDavPrincipal;
import io.milton.principal.DiscretePrincipal;
import io.milton.principal.HrefPrincipleId;
import io.milton.principal.Principal;
import io.milton.resource.Resource;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoPrincipalResource
extends AnnoCollectionResource
implements DiscretePrincipal,
CalDavPrincipal,
DirectoryGatewayCardDavPrincipal {
    private static final Logger log = LoggerFactory.getLogger(AnnoPrincipalResource.class);
    private String email;
    private String cuType;

    public AnnoPrincipalResource(AnnotationResourceFactory outer, Object source, AnnoCollectionResource parent) {
        super(outer, source, parent);
    }

    public HrefList getCalendarHomeSet() {
        try {
            HrefList list = new HrefList();
            if (this.annoFactory.calendarsAnnotationHandler.hasCalendars(this.getSource())) {
                log.info("principal is a direct container of calendars, add: " + this.getHref());
                list.add((Object)this.getHref());
            }
            for (Resource r : Optional.ofNullable(this.getChildren()).orElse(List.of())) {
                AnnoCollectionResource col;
                if (!(r instanceof AnnoCollectionResource) || !this.annoFactory.calendarsAnnotationHandler.hasCalendars((col = (AnnoCollectionResource)r).getSource())) continue;
                log.info("Found child of principal with calendars: " + col.getHref());
                list.add((Object)col.getHref());
            }
            if (list.isEmpty()) {
                ResourceList topDirs = this.getResourceList().getDirs();
                log.warn("Could not find any calendar home directories for user type: " + this.getSource().getClass() + " You should have a @" + Calendars.class + " annotation for the user object itself, or for a directory within the user home");
                for (Resource r : topDirs) {
                    if (r instanceof AnnoCollectionResource) {
                        AnnoCollectionResource col = (AnnoCollectionResource)r;
                        List<ControllerMethod> candMethods = this.annoFactory.calendarsAnnotationHandler.getMethods(col.getSource().getClass());
                        if (candMethods.isEmpty()) {
                            log.info("\t- inspecting: " + col.getName() + " for source: " + col.getSource().getClass() + " - has NO child methods");
                            continue;
                        }
                        log.info("\t- inspecting: " + col.getName() + " for source: " + col.getSource().getClass());
                        for (ControllerMethod cm : candMethods) {
                            log.warn("\t- candidate method: " + cm.controller.getClass() + "::" + cm.method.getName());
                        }
                        continue;
                    }
                    log.warn("\t- found a directory which is not a AnnoCollectionResource: " + r.getClass() + " which cannot be inspected");
                }
            }
            return list;
        }
        catch (BadRequestException | NotAuthorizedException e) {
            throw new RuntimeException(e);
        }
    }

    public HrefList getAddressBookHomeSet() {
        try {
            HrefList list = new HrefList();
            if (this.annoFactory.addressBooksAnnotationHandler.hasAddressBooks(this.getSource())) {
                list.add((Object)this.getHref());
            }
            for (Resource r : Optional.ofNullable(this.getChildren()).orElse(List.of())) {
                AnnoCollectionResource col;
                if (!(r instanceof AnnoCollectionResource) || !this.annoFactory.addressBooksAnnotationHandler.hasAddressBooks((col = (AnnoCollectionResource)r).getSource())) continue;
                list.add((Object)col.getHref());
            }
            return list;
        }
        catch (BadRequestException | NotAuthorizedException e) {
            throw new RuntimeException(e);
        }
    }

    public HrefList getDirectoryGateway() {
        try {
            HrefList list = new HrefList();
            for (Resource r : Optional.ofNullable(this.getChildren()).orElse(List.of())) {
                AnnoCollectionResource col;
                Boolean isDirectoryGateway;
                if (!(r instanceof AnnoCollectionResource) || (isDirectoryGateway = this.annoFactory.directoryGatewayAnnotationHandler.get(col = (AnnoCollectionResource)r)) == null || !isDirectoryGateway.booleanValue()) continue;
                list.add((Object)col.getHref());
            }
            return list;
        }
        catch (BadRequestException | NotAuthorizedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPrincipalURL() {
        return this.getHref();
    }

    public Principal.PrincipleId getIdenitifer() {
        return new HrefPrincipleId(this.getHref());
    }

    public HrefList getCalendarUserAddressSet() {
        String mailto = "mailto:" + this.getEmail();
        return HrefList.asList((String[])new String[]{mailto});
    }

    public SupportedCalendarComponentListsSet getSupportedComponentSets() {
        log.trace("getSupportedComponentSets");
        return this.annoFactory.supportedComponentSets.get(this);
    }

    public String getAddress() {
        return this.getHref();
    }

    public String getEmail() {
        if (this.email == null) {
            this.email = this.annoFactory.emailAnnotationHandler.get(this);
            if (this.email == null) {
                log.info("Constructed email for source class: " + this.source.getClass() + " = " + this.email);
            }
        }
        return this.email;
    }

    public String getCalendarUserType() {
        if (this.cuType == null) {
            this.cuType = this.annoFactory.calendarUserTypeAnnotationHandler.get(this);
        }
        if (this.cuType == null) {
            this.cuType = "INDIVIDUAL";
        }
        return this.cuType;
    }
}

