/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.MakeCollection;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeCollectionAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(MakeCollectionAnnotationHandler.class);

    public MakeCollectionAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, MakeCollection.class, Request.Method.MKCOL);
    }

    public Object execute(AnnoResource res, String newName) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.trace("execute MKCOL method");
        Object source = res.getSource();
        ControllerMethod cm = this.getBestMethod(source.getClass());
        if (cm == null) {
            throw new RuntimeException("Method not found: Annotation=" + MakeCollection.class + " - source object=" + source.getClass());
        }
        try {
            Object o = this.invoke(cm, res, newName);
            if (o == null) {
                throw new RuntimeException("Method returned null object or void: " + cm.controller.getClass() + "::" + cm.method.getName() + " - should return newly created object");
            }
            return o;
        }
        catch (BadRequestException | ConflictException | NotAuthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

