/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.fs;

import io.milton.cache.CacheManager;
import io.milton.http.PropertyManager;
import io.milton.http.webdav.WebDavProtocol;
import io.milton.property.PropertySource;
import io.milton.resource.MultiNamespaceCustomPropertyResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class SimplePropertyManager
implements PropertyManager {
    private final Map<String, Map<QName, Object>> propertiesByUniqueId;

    public SimplePropertyManager(CacheManager cacheManager) {
        this.propertiesByUniqueId = cacheManager.getMap("fuse-properties-byuniqueId");
    }

    public Object getProperty(QName name, MultiNamespaceCustomPropertyResource resource) {
        Map<QName, Object> resourceProperties = this.propertiesByUniqueId.get(resource.getUniqueId());
        if (resourceProperties != null) {
            return resourceProperties.get(name);
        }
        return null;
    }

    public void setProperty(QName name, Object value, MultiNamespaceCustomPropertyResource resource) {
        this.propertiesByUniqueId.computeIfAbsent(resource.getUniqueId(), k -> new HashMap());
        Map<QName, Object> map = this.propertiesByUniqueId.get(resource.getUniqueId());
        if (value == null) {
            map.remove(name);
        } else {
            map.put(name, value);
        }
    }

    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, MultiNamespaceCustomPropertyResource resource) {
        if (!(name.getNamespaceURI().equals(WebDavProtocol.NS_DAV.getName()) || name.getNamespaceURI().contains("caldav") || name.getNamespaceURI().contains("carddav"))) {
            Map<QName, Object> map = this.propertiesByUniqueId.get(resource.getUniqueId());
            if (map != null && map.containsKey(name)) {
                return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.WRITABLE, String.class);
            }
            return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.UNKNOWN, String.class, true);
        }
        return null;
    }

    public List<QName> getAllPropertyNames(MultiNamespaceCustomPropertyResource resource) {
        Map<QName, Object> resourceProperties = this.propertiesByUniqueId.get(resource.getUniqueId());
        if (resourceProperties != null) {
            return new ArrayList<QName>(resourceProperties.keySet());
        }
        return null;
    }
}

