/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.http.Auth;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonPropPatchHandler;
import io.milton.http.json.JsonResource;
import io.milton.http.webdav.PropFindResponse;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropPatchJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(PropPatchJsonResource.class);
    private final Resource wrappedResource;
    private final JsonPropPatchHandler patchHandler;
    private final String encodedUrl;
    private PropFindResponse resp;

    public PropPatchJsonResource(Resource wrappedResource, JsonPropPatchHandler patchHandler, String encodedUrl) {
        super(wrappedResource, Request.Method.PROPPATCH.code, null);
        this.wrappedResource = wrappedResource;
        this.encodedUrl = encodedUrl;
        this.patchHandler = patchHandler;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException {
        log.debug("sendContent");
        JsonConfig cfg = new JsonConfig();
        cfg.setIgnoreTransientFields(true);
        cfg.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        ArrayList<FieldError> errors = new ArrayList<FieldError>();
        if (this.resp != null && this.resp.getErrorProperties() != null) {
            log.debug("error props: " + this.resp.getErrorProperties().size());
            for (Response.Status stat : this.resp.getErrorProperties().keySet()) {
                List props = (List)this.resp.getErrorProperties().get(stat);
                for (PropFindResponse.NameAndError ne : props) {
                    errors.add(new FieldError(ne.getName().getLocalPart(), ne.getError(), stat.code));
                }
            }
        }
        log.debug("errors size: " + errors.size());
        FieldError[] arr = new FieldError[errors.size()];
        arr = errors.toArray(arr);
        PrintWriter writer = new PrintWriter(out);
        JSON json = JSONSerializer.toJSON((Object)arr, (JsonConfig)cfg);
        json.write((Writer)writer);
        ((Writer)writer).flush();
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        this.resp = this.patchHandler.process(this.wrappedResource, this.encodedUrl, parameters);
        return null;
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.PROPPATCH;
    }

    public static class FieldError {
        private String name;
        private String description;
        private int code;

        public FieldError(String name, String description, int code) {
            this.name = name;
            this.description = description;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }
    }
}

