/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.FileItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItemHeaders;

public class FileItemWrapper
implements FileItem {
    final DiskFileItem wrapped;
    final String name;
    private Map<String, String> mapOfHeaders;

    public static String fixIEFileName(String s) {
        if (s.contains("\\")) {
            int pos = s.lastIndexOf(92);
            s = s.substring(pos + 1);
        }
        return s;
    }

    public FileItemWrapper(DiskFileItem wrapped) {
        this.wrapped = wrapped;
        this.name = FileItemWrapper.fixIEFileName(wrapped.getName());
    }

    public String getContentType() {
        return this.wrapped.getContentType();
    }

    public String getFieldName() {
        return this.wrapped.getName();
    }

    public InputStream getInputStream() {
        try {
            return this.wrapped.getInputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public Map<String, String> getHeaders() {
        if (this.mapOfHeaders == null) {
            this.mapOfHeaders = new HashMap<String, String>();
            if (this.wrapped.getHeaders() != null) {
                FileItemHeaders headers = this.wrapped.getHeaders();
                Iterator it = headers.getHeaderNames();
                while (it.hasNext()) {
                    String headerName = (String)it.next();
                    String s = headers.getHeader(headerName);
                    this.mapOfHeaders.put(headerName, s);
                }
            }
        }
        return this.mapOfHeaders;
    }

    public String getPath() {
        return this.wrapped.getPath().toString();
    }
}

