/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.ResourceFactory;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import io.milton.servlet.ServletResource;
import jakarta.servlet.ServletContext;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;

public class ServletResourceFactory
implements ResourceFactory {
    private final ServletContext servletContext;

    @Autowired
    public ServletResourceFactory(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Resource getResource(String host, String path) {
        String contextPath = MiltonServlet.request().getContextPath();
        String localPath = path.substring(contextPath.length());
        String realPath = this.servletContext.getRealPath(localPath);
        if (realPath != null) {
            File file = new File(realPath);
            if (file.exists() && !file.isDirectory()) {
                return new ServletResource(file, localPath, MiltonServlet.request(), MiltonServlet.response());
            }
            return null;
        }
        return null;
    }
}

