/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.http.AbstractRequest;
import io.milton.http.Auth;
import io.milton.http.Cookie;
import io.milton.http.FileItem;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.simpleton.SimpleFileItem;
import io.milton.simpleton.SimpletonCookie;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.http.Address;
import org.simpleframework.http.Form;
import org.simpleframework.http.Part;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMiltonRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(SimpleMiltonRequest.class);
    private final Request baseRequest;
    public final long started;
    private Auth auth;

    public SimpleMiltonRequest(Request baseRequest) {
        this.baseRequest = baseRequest;
        this.started = System.currentTimeMillis();
    }

    @Override
    public String getRequestHeader(Request.Header header) {
        return this.baseRequest.getValue(header.code);
    }

    public String getFromAddress() {
        Address add = this.baseRequest.getAddress();
        if (add == null) {
            return null;
        }
        return add.toString();
    }

    public Request.Method getMethod() {
        String s = this.baseRequest.getMethod().toUpperCase();
        try {
            return Request.Method.valueOf((String)s);
        }
        catch (IllegalArgumentException e) {
            String ua = this.getUserAgentHeader();
            String ip = this.getRemoteAddr();
            throw new RuntimeException("No such method: " + s + " Requested by user-agent: " + ua + " from remote address: " + ip);
        }
    }

    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null) {
            return null;
        }
        if (enc.length() == 0) {
            return null;
        }
        this.auth = new Auth(enc);
        return this.auth;
    }

    public void setAuthorization(Auth auth) {
        this.auth = auth;
    }

    public String getAbsoluteUrl() {
        Object s = this.baseRequest.getTarget();
        if (((String)s).startsWith("http")) {
            log.debug("target: " + (String)s);
        } else {
            String host = this.baseRequest.getValue("Host");
            Address a = this.baseRequest.getAddress();
            if (host == null) {
                host = a.getDomain();
            }
            s = this.baseRequest.isSecure() ? "https" : "http";
            s = (String)s + "://" + host;
            if (a.getPort() != 80 && a.getPort() > 0) {
                s = (String)s + ":" + a.getPort();
            }
            s = (String)s + this.baseRequest.getTarget();
        }
        return s;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.baseRequest.getInputStream();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void parseRequestParameters(Map<String, String> params, Map<String, FileItem> files) throws RequestParseException {
        Form form;
        Query map = this.baseRequest.getQuery();
        params.putAll((Map<String, String>)map);
        try {
            form = this.baseRequest.getForm();
        }
        catch (Exception ex) {
            throw new RequestParseException("", (Throwable)ex);
        }
        if (form == null) {
            return;
        }
        for (Map.Entry entry : form.entrySet()) {
            String nm = (String)entry.getKey();
            String val = (String)entry.getValue();
            params.put(nm, val);
        }
        List list = form.getParts();
        for (Part part : list) {
            String name = part.getName();
            if (!part.isFile()) continue;
            SimpleFileItem item = (SimpleFileItem)files.get(name);
            if (item == null) {
                String filename = SimpleMiltonRequest.truncateFileName(this.getUserAgentHeader(), part.getFileName());
                item = new SimpleFileItem(name, part.getContentType().toString(), filename);
                files.put(name, item);
            }
            item.addPart(part);
        }
        for (FileItem item : files.values()) {
            SimpleFileItem sitem = (SimpleFileItem)item;
            sitem.finishedReadingRequest();
        }
    }

    public static String truncateFileName(String agent, String s) {
        if (agent == null) {
            return s;
        }
        if (agent.contains("MSIE")) {
            if (s.contains("\\")) {
                int pos = s.lastIndexOf("\\");
                return s.substring(pos + 1);
            }
            return s;
        }
        return s;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String s : this.baseRequest.getNames()) {
            String val = this.baseRequest.getValue(s);
            headers.put(s, val);
        }
        return headers;
    }

    public Cookie getCookie(String name) {
        for (org.simpleframework.http.Cookie c : this.baseRequest.getCookies()) {
            if (!c.getName().equals(name)) continue;
            return new SimpletonCookie(c);
        }
        return null;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> list = new ArrayList<Cookie>();
        for (org.simpleframework.http.Cookie c : this.baseRequest.getCookies()) {
            list.add(new SimpletonCookie(c));
        }
        return list;
    }

    public String getRemoteAddr() {
        InetSocketAddress add = this.baseRequest.getClientAddress();
        if (add == null) {
            return null;
        }
        return add.getHostName();
    }
}

